/*
 * Decompiled with CFR 0.152.
 */
package views.components;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import views.components.MenuItem;

public abstract class MenuItemText
extends MenuItem {
    protected String text;
    private Font font;
    private int color;
    private static final int AREA_EXTENSION = 3;

    public abstract void onSelected();

    public void render(Graphics graphics) {
        this.render(graphics, this.getX(), this.getY());
    }

    public void render(Graphics graphics, int n, int n2) {
        if (this.text != null) {
            graphics.setColor(this.color);
            if (this.font != null) {
                graphics.setFont(this.font);
            }
            graphics.drawString(this.text, n, n2, 20);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.setWidthHeight();
    }

    public void setText(String string) {
        this.text = string;
        this.setWidthHeight();
    }

    public void setColor(int n) {
        this.color = n;
    }

    private void setWidthHeight() {
        if (this.font != null && this.text != null) {
            this.setWidth(this.font.charsWidth(this.text.toCharArray(), 0, this.text.length()));
            this.setHeight(this.font.getHeight());
        }
    }

    protected boolean isInside(int n, int n2) {
        return n >= this.getX() - 3 && n < this.getX() + this.getWidth() + 3 && n2 >= this.getY() - 3 && n2 < this.getY() + this.getHeight() + 3;
    }
}

