/*
 * Decompiled with CFR 0.152.
 */
package views.components;

import fonts.TextWriter;
import helpers.ImageFactory;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import views.components.MenuItem;

public abstract class MenuItemImage
extends MenuItem {
    protected Image image;
    protected Image highlightedImage;
    protected Image backgroundImage;
    protected Image overlayImage;
    protected String text;
    protected TextWriter textWriter;

    public MenuItemImage() {
    }

    public MenuItemImage(String string) {
        this.init(string);
    }

    public MenuItemImage(String string, String string2) {
        this.init(string, string2);
    }

    public MenuItemImage(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    private void setImage(String string) {
        try {
            this.image = ImageFactory.getInstance().loadImage(string);
            this.setWidth(this.image.getWidth());
            this.setHeight(this.image.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init(String string) {
        this.setImage(string);
    }

    protected void init(String string, String string2) {
        this.setImage(string);
        try {
            this.highlightedImage = ImageFactory.getInstance().loadImage(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init(String string, String string2, String string3) {
        this.setImage(string);
        try {
            this.highlightedImage = ImageFactory.getInstance().loadImage(string2);
            this.backgroundImage = ImageFactory.getInstance().loadImage(string3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init(String string, String string2, String string3, String string4) {
        this.setImage(string);
        try {
            if (string2 != null) {
                this.highlightedImage = ImageFactory.getInstance().loadImage(string2);
            }
            if (string3 != null) {
                this.backgroundImage = ImageFactory.getInstance().loadImage(string3);
            }
            if (string4 != null) {
                this.overlayImage = ImageFactory.getInstance().loadImage(string4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void onSelected();

    public void render(Graphics graphics) {
        this.render(graphics, this.getX(), this.getY());
    }

    public void render(Graphics graphics, int n, int n2) {
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, n, n2, 20);
        }
        if (this.image != null) {
            if (this.highlightedImage != null && this.isHighlighted()) {
                graphics.drawImage(this.highlightedImage, n, n2, 20);
            } else {
                graphics.drawImage(this.image, n, n2, 20);
            }
        }
        if (this.overlayImage != null) {
            graphics.drawImage(this.overlayImage, n, n2, 20);
        }
        if (this.text != null && this.textWriter != null) {
            this.textWriter.drawCentered(this.text, graphics, n + this.image.getWidth() / 2, n2 + this.image.getHeight() / 2 + 2);
        }
    }
}

