/*
 * Decompiled with CFR 0.152.
 */
package views.components;

import fonts.TextWriter;
import helpers.ImageFactory;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.GameState;
import views.components.MenuItemImage;

public class LevelItem
extends MenuItemImage {
    private int level;
    private boolean locked;
    private Image lockedImage;

    public LevelItem(int n, TextWriter textWriter) {
        this.level = n;
        this.text = String.valueOf(n);
        this.textWriter = textWriter;
        this.init("/menu_levels/button.png", "/menu_levels/button_h.png");
        try {
            this.lockedImage = ImageFactory.getInstance().loadImage("/menu_levels/lock.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onSelected() {
        if (!this.isLocked()) {
            GameState.getInstance().startGame(this.level);
        }
    }

    public void render(Graphics graphics, int n, int n2) {
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, n, n2, 20);
        }
        if (this.highlightedImage != null && this.isHighlighted()) {
            graphics.drawImage(this.highlightedImage, n, n2, 20);
        } else {
            graphics.drawImage(this.image, n, n2, 20);
        }
        if (this.isLocked()) {
            graphics.drawImage(this.lockedImage, n + this.image.getWidth() / 2, n2 + this.image.getHeight() / 2, 3);
        } else if (this.textWriter != null) {
            this.textWriter.drawCentered(this.text, graphics, n + this.image.getWidth() / 2, n2 + this.image.getHeight() / 2 + 2);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public int getLevel() {
        return this.level;
    }
}

