/*
 * Decompiled with CFR 0.152.
 */
package views;

import javax.microedition.lcdui.game.GameCanvas;

public abstract class XDraggableCanvas
extends GameCanvas {
    private int offsetMax;
    private int offsetMin;
    private int moveTime = 100;
    private long logicPeriod = 25L;
    protected int screenWidth = 240;
    private int flickLength;
    private int dragStartX;
    private int offset0;
    private int offset;
    private int increment;
    private boolean moving;
    private int nearestFixedPosition;

    public XDraggableCanvas(boolean bl) {
        super(bl);
        this.init();
    }

    private void init() {
    }

    protected void pointerPressed(int n, int n2) {
        this.dragStartX = n;
        this.moving = false;
        this.offset0 = this.getOffset();
    }

    protected void pointerDragged(int n, int n2) {
        int n3 = n - this.dragStartX;
        this.offset = this.offset0 - n3;
        if (this.offset < this.offsetMin) {
            this.offset = this.offsetMin;
        }
        if (this.offset > this.offsetMax) {
            this.offset = this.offsetMax;
        }
        this.updateLayerPositions();
    }

    protected void pointerReleased(int n, int n2) {
        this.flickLength = Math.abs(this.offset - this.offset0);
        this.nearestFixedPosition = this.flickLength > this.screenWidth / 4 ? (this.offset > this.offset0 ? this.screenWidth * ((this.offset0 + this.screenWidth) / this.screenWidth) : this.screenWidth * ((this.offset0 - this.screenWidth) / this.screenWidth)) : this.screenWidth * ((this.offset + this.screenWidth / 2) / this.screenWidth);
        if (this.offset != this.nearestFixedPosition) {
            this.moving = true;
            this.increment = (int)((long)(this.offset - this.nearestFixedPosition) * this.logicPeriod / (long)this.moveTime);
            if (this.increment == 0 && this.offset > this.nearestFixedPosition) {
                this.increment = 1;
            }
            if (this.increment == 0 && this.offset < this.nearestFixedPosition) {
                this.increment = -1;
            }
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDragDistance(int n) {
        return Math.abs(this.dragStartX - n);
    }

    protected void logic() {
        if (this.moving) {
            this.offset -= this.increment;
            if (this.increment > 0 && this.offset <= this.nearestFixedPosition) {
                this.offset = this.nearestFixedPosition;
                this.moving = false;
            } else if (this.increment < 0 && this.offset >= this.nearestFixedPosition) {
                this.offset = this.nearestFixedPosition;
                this.moving = false;
            } else if (this.increment == 0) {
                this.moving = false;
            }
            this.updateLayerPositions();
        }
    }

    protected abstract void updateLayerPositions();

    public void setLogicPeriod(long l) {
        this.logicPeriod = l;
    }

    public void setOffsetMax(int n) {
        this.offsetMax = n;
    }

    public void setMoveTime(int n) {
        this.moveTime = n;
    }
}

