/*
 * Decompiled with CFR 0.152.
 */
package views;

import helpers.Fader;
import helpers.ImageFactory;
import helpers.Variant;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import main.Main;
import views.components.MenuItem;
import views.components.MenuItemImage;

public class Success
extends GameCanvas {
    public static final int UI_PERIOD = 25;
    private Image background;
    private Timer mTimer;
    private Graphics g;
    private Vector items;
    private Fader fader;
    private int[][] variantCoordinates;
    private int tItemsCount;

    public Success() {
        super(false);
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.init();
    }

    private void init() {
        this.variantCoordinates = new int[2][2];
        if (Variant.isS60()) {
            this.variantCoordinates[0][0] = 9;
            this.variantCoordinates[0][1] = 608;
            this.variantCoordinates[1][0] = 266;
            this.variantCoordinates[1][1] = 608;
        } else {
            this.variantCoordinates[0][0] = 8;
            this.variantCoordinates[0][1] = 294;
            this.variantCoordinates[1][0] = 161;
            this.variantCoordinates[1][1] = 294;
        }
        this.fader = Fader.getInstance();
        try {
            this.background = ImageFactory.getInstance().loadImage("/final/bg.jpg");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.items = new Vector();
        this.addItem(new MenuItemImage("/buttons/menu.png", "/buttons/menu_h.png"){

            public void onSelected() {
                Main.getInstance().showMenu();
            }
        }, this.variantCoordinates[0][0], this.variantCoordinates[0][1]);
        this.addItem(new MenuItemImage("/buttons/about.png", "/buttons/about_h.png"){

            public void onSelected() {
                Main.getInstance().showAbout();
            }
        }, this.variantCoordinates[1][0], this.variantCoordinates[1][1]);
    }

    private void addItem(MenuItem menuItem, int n, int n2) {
        menuItem.setPosition(n, n2);
        this.items.addElement(menuItem);
    }

    public void showNotify() {
        this.fader.setDuration(700L);
        this.fader.setFrom(240);
        this.fader.setTo(0);
        this.fader.reset();
        this.mTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Success.this.render();
                Success.this.flushGraphics();
            }
        };
        this.mTimer.schedule(timerTask, 0L, 25L);
    }

    public void hideNotify() {
        this.mTimer.cancel();
    }

    private void render() {
        this.g.drawImage(this.background, 0, 0, 20);
        this.tItemsCount = this.items.size();
        for (int i = 0; i < this.tItemsCount; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden()) continue;
            ((MenuItem)this.items.elementAt(i)).render(this.g);
        }
        this.fader.render(this.g);
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerPressed(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden() || !((MenuItem)this.items.elementAt(i)).isHighlighted()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerReleased(n, n2);
        }
    }
}

