/*
 * Decompiled with CFR 0.152.
 */
package views;

import fonts.TextWriter;
import fonts.TextWriterFactory;
import helpers.ImageFactory;
import helpers.Variant;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import main.GameState;
import main.Main;
import views.components.MainMenuItem;
import views.components.MenuItem;

public class MenuMain
extends GameCanvas {
    public static final int UI_PERIOD = 25;
    private Image background;
    private Timer mTimer;
    private Graphics g;
    private Vector items;
    private MainMenuItem continueItem;

    public MenuMain() {
        super(false);
        this.setFullScreenMode(true);
        try {
            this.background = ImageFactory.getInstance().loadImage("/menu/bg.jpg");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.g = this.getGraphics();
        this.init();
    }

    private void init() {
        TextWriter textWriter = null;
        try {
            textWriter = TextWriterFactory.getTextWriter(4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[][] nArray = new int[4][2];
        if (Variant.isS60()) {
            nArray[0][0] = 63;
            nArray[0][1] = 235;
            nArray[1][0] = 63;
            nArray[1][1] = 359;
            nArray[2][0] = 63;
            nArray[2][1] = 421;
            nArray[3][0] = 63;
            nArray[3][1] = 484;
        } else {
            nArray[0][0] = 29;
            nArray[0][1] = 77;
            nArray[1][0] = 29;
            nArray[1][1] = 169;
            nArray[2][0] = 29;
            nArray[2][1] = 215;
            nArray[3][0] = 29;
            nArray[3][1] = 261;
        }
        this.items = new Vector();
        this.continueItem = new MainMenuItem("continue", textWriter, "/menu/button_bg_1.png"){

            public void onSelected() {
                if (GameState.getInstance().isStarted()) {
                    Main.getInstance().showGame();
                } else if (GameState.getInstance().isStateInDb()) {
                    GameState.getInstance().continueSavedGame();
                }
            }
        };
        this.addItem(this.continueItem, nArray[0][0], nArray[0][1]);
        this.addItem(new MainMenuItem("new game", textWriter, "/menu/button_bg_2.png"){

            public void onSelected() {
                Main.getInstance().showLevels();
            }
        }, nArray[1][0], nArray[1][1]);
        this.addItem(new MainMenuItem("about", textWriter, "/menu/button_bg_3.png"){

            public void onSelected() {
                Main.getInstance().showAbout();
            }
        }, nArray[2][0], nArray[2][1]);
        this.addItem(new MainMenuItem("exit", textWriter, "/menu/button_bg_4.png"){

            public void onSelected() {
                Main.getInstance().exit();
            }
        }, nArray[3][0], nArray[3][1]);
        if (GameState.getInstance().isStarted()) {
            this.continueItem.setHidden(false);
        } else if (GameState.getInstance().isStateInDb()) {
            this.continueItem.setHidden(false);
        } else {
            this.continueItem.setHidden(true);
        }
    }

    public final void addItem(MenuItem menuItem, int n, int n2) {
        menuItem.setPosition(n, n2);
        this.items.addElement(menuItem);
    }

    public void showNotify() {
        this.mTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                MenuMain.this.render();
                MenuMain.this.flushGraphics();
            }
        };
        this.mTimer.schedule(timerTask, 0L, 25L);
        if (GameState.getInstance().isStarted()) {
            this.continueItem.setHidden(false);
        }
    }

    public void hideNotify() {
        this.mTimer.cancel();
    }

    private void render() {
        this.g.drawImage(this.background, 0, 0, 20);
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden()) continue;
            ((MenuItem)this.items.elementAt(i)).render(this.g);
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerPressed(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden() || !((MenuItem)this.items.elementAt(i)).isHighlighted()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerReleased(n, n2);
        }
    }
}

