/*
 * Decompiled with CFR 0.152.
 */
package views;

import fonts.TextWriter;
import fonts.TextWriterFactory;
import helpers.ImageFactory;
import helpers.Util;
import helpers.Variant;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.GameState;
import main.Main;
import views.XDraggableCanvas;
import views.components.LevelItem;
import views.components.MenuItem;
import views.components.MenuItemImage;

public class MenuLevels
extends XDraggableCanvas {
    private static final long UI_PERIOD = 25L;
    private static final long LOGIC_PERIOD = 25L;
    private static final long DRAG_PERIOD = 25L;
    private static final int XOR_KEY = 586;
    private int[] keySequence;
    private boolean changed;
    private Image background;
    private Image dots;
    private Image dotMarker;
    private Image logo;
    private Timer mTimer;
    private Graphics g;
    private Vector items;
    private TextWriter textwriter;
    private int buttonWidth;
    private int markerPosition;
    private int buttonsOffset;
    private int backgroundOffset;
    private boolean hightlightReseted;
    private long lastDragTimestamp;
    private MenuItem tItem;
    private int tItemsCount;
    private long tTimeStamp;
    private int[][] variantCoordinates;

    public MenuLevels() {
        super(false);
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.init();
    }

    private void init() {
        this.variantCoordinates = new int[5][5];
        if (Variant.isS60()) {
            this.buttonWidth = 82;
            this.screenWidth = 360;
            this.variantCoordinates[0][0] = 9;
            this.variantCoordinates[0][1] = 96;
            this.variantCoordinates[0][2] = 183;
            this.variantCoordinates[0][3] = 270;
            this.variantCoordinates[1][0] = 155;
            this.variantCoordinates[1][1] = 242;
            this.variantCoordinates[1][2] = 329;
            this.variantCoordinates[1][3] = 416;
            this.variantCoordinates[1][4] = 503;
            this.variantCoordinates[2][0] = 8;
            this.variantCoordinates[2][1] = 608;
            this.variantCoordinates[3][0] = 270;
            this.variantCoordinates[3][1] = 615;
            this.variantCoordinates[4][0] = 266;
            this.variantCoordinates[4][1] = 612;
            this.variantCoordinates[4][2] = 10;
            this.setOffsetMax(2520);
        } else {
            this.buttonWidth = 64;
            this.screenWidth = 240;
            this.variantCoordinates[0][0] = 8;
            this.variantCoordinates[0][1] = 65;
            this.variantCoordinates[0][2] = 122;
            this.variantCoordinates[0][3] = 179;
            this.variantCoordinates[1][0] = 11;
            this.variantCoordinates[1][1] = 66;
            this.variantCoordinates[1][2] = 122;
            this.variantCoordinates[1][3] = 176;
            this.variantCoordinates[1][4] = 232;
            this.variantCoordinates[2][0] = 8;
            this.variantCoordinates[2][1] = 294;
            this.variantCoordinates[3][0] = 150;
            this.variantCoordinates[3][1] = 300;
            this.variantCoordinates[4][0] = 146;
            this.variantCoordinates[4][1] = 297;
            this.variantCoordinates[4][2] = 10;
            this.setOffsetMax(1680);
        }
        try {
            this.background = ImageFactory.getInstance().loadImage("/menu_levels/bg.jpg");
            this.dots = ImageFactory.getInstance().loadImage("/menu_levels/dots.png");
            this.dotMarker = ImageFactory.getInstance().loadImage("/menu_levels/marker.png");
            if (Variant.isS60()) {
                this.logo = ImageFactory.getInstance().loadImage("/menu_levels/logo.png");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.keySequence = new int[7];
        this.textwriter = TextWriterFactory.getTextWriter(2);
        this.setLogicPeriod(25L);
        this.setMoveTime(200);
        int n = 20;
        this.items = new Vector();
        for (int i = 0; i < 8; ++i) {
            this.addItem(new LevelItem(1 + i * n, this.textwriter), this.variantCoordinates[0][0] + this.screenWidth * i, this.variantCoordinates[1][0], 1);
            this.addItem(new LevelItem(2 + i * n, this.textwriter), this.variantCoordinates[0][1] + this.screenWidth * i, this.variantCoordinates[1][0], 1);
            this.addItem(new LevelItem(3 + i * n, this.textwriter), this.variantCoordinates[0][2] + this.screenWidth * i, this.variantCoordinates[1][0], 1);
            this.addItem(new LevelItem(4 + i * n, this.textwriter), this.variantCoordinates[0][3] + this.screenWidth * i, this.variantCoordinates[1][0], 1);
            this.addItem(new LevelItem(5 + i * n, this.textwriter), this.variantCoordinates[0][0] + this.screenWidth * i, this.variantCoordinates[1][1], 1);
            this.addItem(new LevelItem(6 + i * n, this.textwriter), this.variantCoordinates[0][1] + this.screenWidth * i, this.variantCoordinates[1][1], 1);
            this.addItem(new LevelItem(7 + i * n, this.textwriter), this.variantCoordinates[0][2] + this.screenWidth * i, this.variantCoordinates[1][1], 1);
            this.addItem(new LevelItem(8 + i * n, this.textwriter), this.variantCoordinates[0][3] + this.screenWidth * i, this.variantCoordinates[1][1], 1);
            this.addItem(new LevelItem(9 + i * n, this.textwriter), this.variantCoordinates[0][0] + this.screenWidth * i, this.variantCoordinates[1][2], 1);
            this.addItem(new LevelItem(10 + i * n, this.textwriter), this.variantCoordinates[0][1] + this.screenWidth * i, this.variantCoordinates[1][2], 1);
            this.addItem(new LevelItem(11 + i * n, this.textwriter), this.variantCoordinates[0][2] + this.screenWidth * i, this.variantCoordinates[1][2], 1);
            this.addItem(new LevelItem(12 + i * n, this.textwriter), this.variantCoordinates[0][3] + this.screenWidth * i, this.variantCoordinates[1][2], 1);
            this.addItem(new LevelItem(13 + i * n, this.textwriter), this.variantCoordinates[0][0] + this.screenWidth * i, this.variantCoordinates[1][3], 1);
            this.addItem(new LevelItem(14 + i * n, this.textwriter), this.variantCoordinates[0][1] + this.screenWidth * i, this.variantCoordinates[1][3], 1);
            this.addItem(new LevelItem(15 + i * n, this.textwriter), this.variantCoordinates[0][2] + this.screenWidth * i, this.variantCoordinates[1][3], 1);
            this.addItem(new LevelItem(16 + i * n, this.textwriter), this.variantCoordinates[0][3] + this.screenWidth * i, this.variantCoordinates[1][3], 1);
            this.addItem(new LevelItem(17 + i * n, this.textwriter), this.variantCoordinates[0][0] + this.screenWidth * i, this.variantCoordinates[1][4], 1);
            this.addItem(new LevelItem(18 + i * n, this.textwriter), this.variantCoordinates[0][1] + this.screenWidth * i, this.variantCoordinates[1][4], 1);
            this.addItem(new LevelItem(19 + i * n, this.textwriter), this.variantCoordinates[0][2] + this.screenWidth * i, this.variantCoordinates[1][4], 1);
            this.addItem(new LevelItem(20 + i * n, this.textwriter), this.variantCoordinates[0][3] + this.screenWidth * i, this.variantCoordinates[1][4], 1);
        }
        this.addItem(new MenuItemImage("/buttons/menu.png", "/buttons/menu_h.png"){

            public void onSelected() {
                Main.getInstance().showMenu();
            }
        }, this.variantCoordinates[2][0], this.variantCoordinates[2][1]);
    }

    private void addItem(MenuItem menuItem, int n, int n2, int n3) {
        menuItem.setPosition(n, n2);
        menuItem.setGroup(n3);
        this.items.addElement(menuItem);
    }

    private void addItem(MenuItem menuItem, int n, int n2) {
        menuItem.setPosition(n, n2);
        this.items.addElement(menuItem);
    }

    public void showNotify() {
        this.mTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                MenuLevels.this.render();
                MenuLevels.this.flushGraphics();
            }
        };
        this.mTimer.schedule(timerTask, 0L, 25L);
        TimerTask timerTask2 = new TimerTask(){

            public void run() {
                MenuLevels.this.logic();
            }
        };
        this.mTimer.schedule(timerTask2, 0L, 25L);
        this.updateLevelsLock();
        this.changed = true;
    }

    public void hideNotify() {
        this.mTimer.cancel();
    }

    private void render() {
        if (this.changed) {
            this.g.drawImage(this.background, -this.backgroundOffset, 0, 20);
            if (this.logo != null) {
                this.g.drawImage(this.logo, 0, 40, 20);
            }
            this.g.drawImage(this.dots, this.variantCoordinates[3][0], this.variantCoordinates[3][1], 20);
            this.g.drawImage(this.dotMarker, this.variantCoordinates[4][0] + this.markerPosition * this.variantCoordinates[4][2], this.variantCoordinates[4][1], 20);
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                MenuItem menuItem = (MenuItem)this.items.elementAt(i);
                if (menuItem.getGroup() == 1) {
                    int n2 = menuItem.getX() - this.buttonsOffset;
                    if (n2 <= -this.buttonWidth || n2 >= this.screenWidth) continue;
                    menuItem.render(this.g, menuItem.getX() - this.buttonsOffset, menuItem.getY());
                    continue;
                }
                menuItem.render(this.g);
            }
            this.changed = false;
        }
    }

    protected void logic() {
        super.logic();
        this.changed = true;
    }

    protected void pointerPressed(int n, int n2) {
        this.tItemsCount = this.items.size();
        for (int i = 0; i < this.tItemsCount; ++i) {
            this.tItem = (MenuItem)this.items.elementAt(i);
            if (this.tItem.isHidden()) continue;
            if (this.tItem instanceof LevelItem) {
                if (((LevelItem)this.tItem).isLocked()) continue;
                if (this.tItem.getGroup() == 1) {
                    this.tItem.pointerPressed(n + this.getOffset(), n2);
                    continue;
                }
                this.tItem.pointerPressed(n, n2);
                continue;
            }
            this.tItem.pointerPressed(n, n2);
        }
        this.changed = true;
        this.hightlightReseted = false;
        super.pointerPressed(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        if (this.getDragDistance(n) < this.buttonWidth) {
            this.tItemsCount = this.items.size();
            for (int i = 0; i < this.tItemsCount; ++i) {
                this.tItem = (MenuItem)this.items.elementAt(i);
                if (!this.tItem.isHidden() && this.tItem.isHighlighted()) {
                    if (this.tItem.getGroup() == 1) {
                        this.tItem.pointerReleased(n + this.getOffset(), n2);
                    } else {
                        this.tItem.pointerReleased(n, n2);
                    }
                }
                this.tItem.setHighlighted(false);
            }
        }
        this.changed = true;
        super.pointerReleased(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.tTimeStamp = System.currentTimeMillis();
        if (this.tTimeStamp - this.lastDragTimestamp > 25L) {
            if (!this.hightlightReseted && this.getDragDistance(n) > this.buttonWidth) {
                this.tItemsCount = this.items.size();
                for (int i = 0; i < this.tItemsCount; ++i) {
                    ((MenuItem)this.items.elementAt(i)).setHighlighted(false);
                }
                this.hightlightReseted = true;
            }
            super.pointerDragged(n, n2);
            this.changed = true;
            this.lastDragTimestamp = this.tTimeStamp;
        }
    }

    private void updateLevelsLock() {
        int n = GameState.getInstance().getMaxSolvedLevel();
        int n2 = this.items.size();
        for (int i = 0; i < n2; ++i) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            if (!(menuItem instanceof LevelItem)) continue;
            if (((LevelItem)menuItem).getLevel() <= n + 1) {
                ((LevelItem)this.items.elementAt(i)).setLocked(false);
                continue;
            }
            ((LevelItem)this.items.elementAt(i)).setLocked(true);
        }
        this.changed = true;
    }

    protected void keyReleased(int n) {
        Util.arrayShift(this.keySequence);
        int n2 = -1;
        if (n == 48) {
            n2 = 0;
        } else if (n == 49) {
            n2 = 1;
        } else if (n == 50) {
            n2 = 2;
        } else if (n == 51) {
            n2 = 3;
        } else if (n == 52) {
            n2 = 4;
        } else if (n == 53) {
            n2 = 5;
        } else if (n == 54) {
            n2 = 6;
        } else if (n == 55) {
            n2 = 7;
        } else if (n == 56) {
            n2 = 8;
        } else if (n == 57) {
            n2 = 9;
        }
        if (n2 >= 0 && n2 <= 9) {
            this.keySequence[0] = n2;
            this.verifyKeySequence();
        }
    }

    private void verifyKeySequence() {
        int n = 100 * this.keySequence[2] + 10 * this.keySequence[1] + this.keySequence[0] ^ 0x24A;
        int n2 = (n * n ^ 0x24A) % 9999;
        int n3 = 1000 * this.keySequence[6] + 100 * this.keySequence[5] + 10 * this.keySequence[4] + this.keySequence[3];
        if (n2 == n3) {
            GameState.getInstance().setMaxSolvedLevel(n);
            this.updateLevelsLock();
        }
    }

    protected void updateLayerPositions() {
        this.buttonsOffset = this.getOffset();
        this.backgroundOffset = this.getOffset() / 4;
        this.markerPosition = (this.getOffset() + 1) / this.screenWidth;
    }
}

