/*
 * Decompiled with CFR 0.152.
 */
package views;

import fonts.TextWriter;
import fonts.TextWriter3;
import fonts.TextWriterFactory;
import gameobjects.GameWorld;
import helpers.Antialias;
import helpers.Fader;
import helpers.ImageLoader;
import helpers.LevelStyle;
import helpers.Profiler;
import helpers.Util;
import helpers.Variant;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import main.GameState;
import main.LevelData;
import main.Main;
import views.components.MenuItemImage;

public class GameView
extends GameCanvas {
    public static final int UI_PERIOD = 25;
    public static final int LOGIC_PERIOD = 50;
    public static final int DRAG_PERIOD = 20;
    private static final long FADE_OUT_DURATION = 500L;
    private Graphics g;
    private Antialias aa;
    private Fader fader;
    private TextWriter textwriter5;
    private TextWriter3 textwriter3;
    private Image backgroundImage;
    private Image helpImage;
    private MenuItemImage pause;
    private Font font;
    private String continueText;
    private int continueTextWidth;
    private int continueTextFlickPeriod = 800;
    private Timer mTimer;
    private GameWorld world;
    private GameState state;
    private long lastDragTimestamp;
    private long startedTimestamp;
    private long solvedTimestamp;
    private int x0;
    private int y0;
    private boolean solved;
    private boolean showSolvedInfo;
    private boolean tapToNextLevel;
    private boolean loadingLevel;
    private boolean starting;
    private long startingFlashLength = 250L;
    private long currentTimeStamp;
    private int[][] variantCoordinates;
    private int tLevel;
    private int renderCounter;

    public GameView() {
        super(false);
        this.setFullScreenMode(true);
        this.init();
        this.reset();
    }

    private void reset() {
        this.solvedTimestamp = 0L;
        this.solved = false;
        this.showSolvedInfo = false;
        this.tapToNextLevel = false;
    }

    private void init() {
        this.g = this.getGraphics();
        this.variantCoordinates = new int[1][2];
        if (Variant.isS60()) {
            this.aa = new Antialias(360, 640);
            this.variantCoordinates[0][0] = 48;
            this.variantCoordinates[0][1] = 14;
        } else {
            this.aa = new Antialias(240, 320);
            this.variantCoordinates[0][0] = 39;
            this.variantCoordinates[0][1] = 11;
        }
        this.textwriter5 = TextWriterFactory.getTextWriter(5);
        this.textwriter3 = new TextWriter3();
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fader = Fader.getInstance();
        this.continueText = "tap to continue...";
        this.state = GameState.getInstance();
        this.world = GameWorld.getInstance();
        try {
            this.helpImage = ImageLoader.loadImage("/game/help.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pause = new MenuItemImage("/game/pause.png", "/game/pause_h.png"){

            public void onSelected() {
                Main.getInstance().showMenu();
            }
        };
        this.pause.setPosition(1, 1);
    }

    public void startLevel() {
        if (this.state.getLevel() >= 1 && this.state.getLevel() <= 40) {
            LevelStyle.setStyle(1);
        } else if (this.state.getLevel() >= 41 && this.state.getLevel() <= 80) {
            LevelStyle.setStyle(2);
        } else if (this.state.getLevel() >= 81 && this.state.getLevel() <= 100) {
            LevelStyle.setStyle(3);
        } else if (this.state.getLevel() >= 101 && this.state.getLevel() <= 120) {
            LevelStyle.setStyle(4);
        } else if (this.state.getLevel() >= 121 && this.state.getLevel() <= 140) {
            LevelStyle.setStyle(5);
        } else if (this.state.getLevel() >= 141 && this.state.getLevel() <= 160) {
            LevelStyle.setStyle(6);
        } else {
            LevelStyle.setStyle(1);
        }
        this.loadingLevel = true;
        this.tLevel = this.state.getLevel();
        this.reset();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.world.startLevel();
        try {
            this.backgroundImage = ImageLoader.loadImage(LevelStyle.getLevelImage("bg.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadingLevel = false;
        this.starting = true;
        this.startedTimestamp = System.currentTimeMillis();
    }

    public void showNotify() {
        this.fader.setDuration(500L);
        this.fader.setFrom(0);
        this.fader.setTo(220);
        this.fader.reset();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                GameView.this.render();
                GameView.this.flushGraphics();
            }
        };
        TimerTask timerTask2 = new TimerTask(){

            public void run() {
                GameView.this.logic();
            }
        };
        this.mTimer = new Timer();
        this.mTimer.schedule(timerTask, 0L, 25L);
        this.mTimer.schedule(timerTask2, 0L, 50L);
        if (!this.world.isAlive()) {
            this.world.start();
        }
        this.world.setPaused(false);
        if (!this.state.isAlive()) {
            this.state.start();
        }
        this.state.setPaused(false);
    }

    protected void hideNotify() {
        this.world.setPaused(true);
        this.state.setPaused(true);
        this.mTimer.cancel();
    }

    private void render() {
        if (!this.loadingLevel) {
            if (this.starting) {
                int n = (int)(200L * (System.currentTimeMillis() - this.startedTimestamp) / this.startingFlashLength);
                if (n > 200) {
                    n = 200;
                }
                this.g.setColor(n, n, n);
                this.g.fillRect(0, 0, Variant.getWidth(), Variant.getHeight());
            } else {
                this.g.drawImage(this.backgroundImage, 0, 0, 20);
                if (this.tLevel == 1) {
                    this.g.drawImage(this.helpImage, 0, 0, 20);
                }
                this.world.renderMarker(this.g);
                if (this.tLevel > 140) {
                    if (this.renderCounter % 3 == 0) {
                        this.world.draw(this.aa);
                    }
                    this.aa.render(this.g);
                    if (this.renderCounter % 3 == 2) {
                        this.aa.zero();
                    }
                } else {
                    if (this.renderCounter % 2 == 0) {
                        this.world.draw(this.aa);
                    }
                    this.aa.render(this.g);
                    if (this.renderCounter % 2 == 1) {
                        this.aa.zero();
                    }
                }
                ++this.renderCounter;
                this.textwriter5.draw("Level " + this.state.getLevel(), this.g, this.variantCoordinates[0][0], this.variantCoordinates[0][1]);
                this.world.render(this.g);
                this.pause.render(this.g, this.pause.getX(), this.pause.getY());
            }
            if (this.solved) {
                this.fader.render(this.g);
                if (this.showSolvedInfo) {
                    if ((System.currentTimeMillis() - this.solvedTimestamp) / (long)this.continueTextFlickPeriod % 2L == 1L) {
                        if (this.continueTextWidth == 0) {
                            this.continueTextWidth = this.font.charsWidth(this.continueText.toCharArray(), 0, this.continueText.length() - 3);
                        }
                        this.g.setColor(0xFFFFFF);
                        this.g.setFont(this.font);
                        this.g.drawString(this.continueText, (Variant.getWidth() - this.continueTextWidth) / 2, Variant.getHeight() - 30, 20);
                    }
                    this.textwriter3.drawCentered("Level " + this.state.getLevel(), this.g, Variant.getWidth() / 2, Variant.getHeight() / 2 - 40);
                    this.textwriter3.drawCentered("is solved", this.g, Variant.getWidth() / 2, Variant.getHeight() / 2 - 10);
                }
            }
        }
    }

    private void logic() {
        if (this.starting && System.currentTimeMillis() - this.startedTimestamp > this.startingFlashLength) {
            this.starting = false;
        }
        if (!this.solved && this.state.isSolved()) {
            this.solved = true;
            this.solvedTimestamp = System.currentTimeMillis();
        } else if (this.solved) {
            long l = System.currentTimeMillis();
            if (l - this.solvedTimestamp > 200L) {
                this.showSolvedInfo = true;
            }
            if (l - this.solvedTimestamp > 250L) {
                this.tapToNextLevel = true;
            }
        }
    }

    private void renderDebugData() {
        this.g.setColor(0xFFFFFF);
        this.g.setFont(Font.getFont((int)0, (int)0, (int)8));
        String[] stringArray = Util.split(Profiler.getInstance().getReport(), "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.g.drawString(stringArray[i], 10, 50 + i * 15, 20);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (!this.tapToNextLevel) {
            this.x0 = n;
            this.y0 = n2;
            this.pause.pointerPressed(n, n2);
        } else {
            int n3 = this.state.getLevel() + 1;
            if (n3 <= LevelData.getInstance().levelCount()) {
                this.state.startGame(n3);
            } else {
                Main.getInstance().showFinalScene();
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (!this.tapToNextLevel) {
            this.x0 = 0;
            this.y0 = 0;
            this.world.drop(n, n2);
            if (this.pause.isHighlighted()) {
                this.pause.pointerReleased(n, n2);
            }
        }
    }

    protected void pointerDragged(int n, int n2) {
        this.currentTimeStamp = System.currentTimeMillis();
        if (this.currentTimeStamp - this.lastDragTimestamp > 20L) {
            this.world.drag(this.x0, this.y0, n, n2);
            this.lastDragTimestamp = this.currentTimeStamp;
        }
    }
}

