/*
 * Decompiled with CFR 0.152.
 */
package views;

import helpers.Fader;
import helpers.ImageFactory;
import helpers.Variant;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import main.Main;
import views.components.MenuItem;
import views.components.MenuItemImage;
import views.components.MenuItemText;

public class About
extends GameCanvas {
    public static final int UI_PERIOD = 25;
    private static final String OVI_URL = "http://store.ovi.com/content/254290";
    private Image background;
    private Timer mTimer;
    private Graphics g;
    private Vector items;
    private Fader fader;
    private int[][] variantCoordinates;
    private MenuItemText store;

    public About() {
        super(false);
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.init();
    }

    private void init() {
        this.variantCoordinates = new int[2][2];
        if (Variant.isS60()) {
            this.variantCoordinates[0][0] = 12;
            this.variantCoordinates[0][1] = 25;
            this.variantCoordinates[1][0] = 7;
            this.variantCoordinates[1][1] = 608;
        } else {
            this.variantCoordinates[0][0] = 12;
            this.variantCoordinates[0][1] = 25;
            this.variantCoordinates[1][0] = 9;
            this.variantCoordinates[1][1] = 294;
        }
        this.fader = Fader.getInstance();
        try {
            this.background = ImageFactory.getInstance().loadImage("/menu/bg.jpg");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.items = new Vector();
        this.addItem(new MenuItemImage("/buttons/menu.png", "/buttons/menu_h.png"){

            public void onSelected() {
                Main.getInstance().showMenu();
            }
        }, this.variantCoordinates[1][0], this.variantCoordinates[1][1]);
        this.store = new MenuItemText(){

            public void onSelected() {
                try {
                    Main.getInstance().platformRequest(About.OVI_URL);
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {
                    // empty catch block
                }
            }
        };
        this.store.setText("Nokia Store");
        this.store.setFont(Font.getFont((int)0, (int)4, (int)8));
        this.store.setColor(16773517);
        this.store.setHidden(true);
        this.addItem(this.store, 0, 0);
    }

    private void addItem(MenuItem menuItem, int n, int n2) {
        menuItem.setPosition(n, n2);
        this.items.addElement(menuItem);
    }

    public void showNotify() {
        this.fader.setDuration(300L);
        this.fader.setFrom(0);
        this.fader.setTo(210);
        this.fader.reset();
        this.mTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                About.this.render();
                About.this.flushGraphics();
            }
        };
        this.mTimer.schedule(timerTask, 0L, 25L);
    }

    public void hideNotify() {
        this.mTimer.cancel();
    }

    private void render() {
        int n;
        int n2;
        this.g.drawImage(this.background, 0, 0, 20);
        this.fader.render(this.g);
        if (this.fader.isEnded()) {
            n2 = this.variantCoordinates[0][0];
            n = this.variantCoordinates[0][1];
            this.g.setColor(0xFFFFFF);
            this.g.setFont(Font.getFont((int)0, (int)0, (int)8));
            this.g.drawString("Untangle RE (version " + Main.getInstance().getAppProperty("MIDlet-Version") + ")", n2, n, 20);
            this.g.drawString("This is a simple logic game.", n2, n += 2 * this.g.getFont().getHeight(), 20);
            this.g.drawString("Move balls to untangle the net.", n2, n += this.g.getFont().getHeight(), 20);
            this.g.drawString("Developed by Sergey Novikov.", n2, n += 2 * this.g.getFont().getHeight(), 20);
            this.g.drawString("You can contact me by e-mail:", n2, n += this.g.getFont().getHeight(), 20);
            this.g.drawString("untangle.re@gmail.com", n2, n += this.g.getFont().getHeight(), 20);
            this.g.drawString("If you liked the game", n2, n += 2 * this.g.getFont().getHeight(), 20);
            this.g.drawString("please leave a comment", n2, n += this.g.getFont().getHeight(), 20);
            String string = "in the ";
            this.g.drawString(string, n2, n += this.g.getFont().getHeight(), 20);
            if (this.store.isHidden()) {
                this.store.setX(n2 + this.g.getFont().charsWidth(string.toCharArray(), 0, string.length()));
                this.store.setY(n);
                this.store.setHidden(false);
            }
            this.g.setColor(0xFFFFFF);
            this.g.setFont(Font.getFont((int)0, (int)0, (int)8));
            this.g.drawString("Thank you.", n2, n += 2 * this.g.getFont().getHeight(), 20);
            n += this.g.getFont().getHeight();
        }
        if (this.fader.isEnded()) {
            n2 = this.items.size();
            for (n = 0; n < n2; ++n) {
                if (((MenuItem)this.items.elementAt(n)).isHidden()) continue;
                ((MenuItem)this.items.elementAt(n)).render(this.g);
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerPressed(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            if (((MenuItem)this.items.elementAt(i)).isHidden() || !((MenuItem)this.items.elementAt(i)).isHighlighted()) continue;
            ((MenuItem)this.items.elementAt(i)).pointerReleased(n, n2);
        }
    }
}

