/*
 * Decompiled with CFR 0.152.
 */
package main;

import helpers.FixedThread;
import helpers.Util;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import main.LevelData;
import main.Main;

public class GameState
extends FixedThread {
    private int levelNum;
    private String levelString;
    private int time;
    private boolean started = false;
    private boolean paused = true;
    private boolean solved;
    private long lastTimestamp;
    private int maxSolvedLevel = -1;
    private static final String RECORD_STORE_NAME = "main";
    private static final int RECORD_ID_MAX_SOLVED_LEVEL = 1;
    private static final int RECORD_ID_WORLD_SATE = 2;
    private static final int MAX_LEVEL = 160;
    private static GameState self = null;

    protected GameState() {
        this.setPeriod(100);
        this.loadMaxSolvedLevelFromDb();
    }

    public static GameState getInstance() {
        if (self == null) {
            self = new GameState();
        }
        return self;
    }

    protected void tick() {
        if (!this.isPaused()) {
            if (this.lastTimestamp > 0L) {
                long l = System.currentTimeMillis();
                this.time = (int)((long)this.time + (l - this.lastTimestamp));
            }
            this.lastTimestamp = System.currentTimeMillis();
        }
    }

    public int getLevel() {
        return this.levelNum;
    }

    private void setLevel(int n) {
        this.levelNum = n;
        this.setSolved(false);
    }

    public int getTime() {
        return this.time;
    }

    private void setTime(int n) {
        this.time = n;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
        this.lastTimestamp = bl ? 0L : System.currentTimeMillis();
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void setSolved(boolean bl) {
        this.solved = bl;
        if (bl) {
            if (this.levelNum > this.maxSolvedLevel) {
                this.setMaxSolvedLevel(this.levelNum);
            }
            this.setPaused(true);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void setStarted(boolean bl) {
        this.started = bl;
    }

    private void loadMaxSolvedLevelFromDb() {
        block4: {
            try {
                RecordStore recordStore;
                try {
                    recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)false);
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                    recordStore = this.createDbAndInitRecords();
                }
                this.maxSolvedLevel = Util.byteArrayToInt(recordStore.getRecord(1));
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                if (this.maxSolvedLevel >= 0) break block4;
                this.maxSolvedLevel = 0;
            }
        }
    }

    private RecordStore createDbAndInitRecords() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            recordStore.addRecord(Util.intToByteArray(0), 0, 4);
            recordStore.addRecord(new byte[]{0}, 0, 1);
            return recordStore;
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
    }

    private void saveMaxSolvedLevelToDb() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            recordStore.setRecord(1, Util.intToByteArray(this.maxSolvedLevel), 0, 4);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public int getMaxSolvedLevel() {
        if (this.maxSolvedLevel == -1) {
            this.loadMaxSolvedLevelFromDb();
        }
        return this.maxSolvedLevel;
    }

    public void setMaxSolvedLevel(int n) {
        if (n > 0 && n <= 160 && n > this.maxSolvedLevel) {
            this.maxSolvedLevel = n;
            this.saveMaxSolvedLevelToDb();
        }
    }

    private void loadStateFromDb() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            try {
                String string = new String(recordStore.getRecord(2));
                String[] stringArray = Util.split(string, ":");
                if (stringArray.length > 1) {
                    this.levelNum = Integer.parseInt(stringArray[0]);
                    this.time = Integer.parseInt(stringArray[1]);
                    this.solved = Integer.parseInt(stringArray[2]) == 1;
                    this.levelString = stringArray[3];
                }
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                invalidRecordIDException.printStackTrace();
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void saveStateToDb(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            String string2 = this.levelNum + ":" + this.time + ":" + (this.solved ? 1 : 0) + ":" + string;
            byte[] byArray = string2.getBytes();
            recordStore.setRecord(2, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public boolean isStateInDb() {
        boolean bl = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            try {
                String string = new String(recordStore.getRecord(2));
                String[] stringArray = Util.split(string, ":");
                if (stringArray.length > 1) {
                    bl = true;
                }
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                // empty catch block
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return bl;
    }

    public void startGame(int n) {
        if (n <= 0) {
            throw new NullPointerException("Level is not set");
        }
        this.levelNum = n;
        LevelData.getInstance().load(this.levelNum);
        this.time = 0;
        this.setStarted(true);
        this.paused = false;
        this.solved = false;
        this.lastTimestamp = 0L;
        Main.getInstance().getGameView().startLevel();
        Main.getInstance().showGame();
    }

    public void continueSavedGame() {
        this.levelString = null;
        this.loadStateFromDb();
        if (this.levelString == null) {
            throw new NullPointerException("Level is not set");
        }
        LevelData.getInstance().parse(this.levelString);
        this.setStarted(true);
        this.paused = false;
        this.lastTimestamp = 0L;
        Main.getInstance().getGameView().startLevel();
        Main.getInstance().showGame();
    }
}

