/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.Variant;
import javax.microedition.lcdui.Graphics;

public class Fader {
    private int[] rgb;
    private int from;
    private int to;
    private int current;
    private long start;
    private long duration;
    private long time;
    private static Fader self = null;
    private final int width;
    private final int height;
    private final int size;

    private Fader() {
        if (Variant.isS60()) {
            this.width = 360;
            this.height = 640;
        } else {
            this.width = 240;
            this.height = 320;
        }
        this.size = this.width * this.height;
        this.rgb = new int[this.size];
    }

    public static Fader getInstance() {
        if (self == null) {
            self = new Fader();
        }
        return self;
    }

    private void arrayFill(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 > 0) {
            nArray[0] = n;
            for (int i = 1; i < n2; i += i) {
                System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
            }
        }
    }

    private void draw(Graphics graphics, int n) {
        if (this.rgb[0] != n) {
            this.arrayFill(this.rgb, n);
        }
        graphics.drawRGB(this.rgb, 0, this.width, 0, 0, this.width, this.height, true);
    }

    public void reset() {
        this.start = 0L;
    }

    public void render(Graphics graphics) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
            this.current = this.from;
        } else if (this.from < this.to && this.current < this.to || this.from > this.to && this.current > this.to) {
            this.time = System.currentTimeMillis();
            this.current = this.from + (this.to - this.from) * (int)(this.time - this.start) / (int)this.duration;
            if (this.from < this.to && this.current > this.to || this.from > this.to && this.current < this.to) {
                this.current = this.to;
            }
        }
        this.draw(graphics, this.current << 24);
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int n) {
        this.from = n;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int n) {
        this.to = n;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public boolean isEnded() {
        return System.currentTimeMillis() - this.start > this.duration;
    }
}

