/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import fp.FP;
import gameobjects.Ball;
import gameobjects.Circle;
import gameobjects.Edge;
import gameobjects.GameObject;
import gameobjects.Marker;
import helpers.Antialias;
import helpers.FixedThread;
import helpers.Variant;
import javax.microedition.lcdui.Graphics;
import main.GameState;
import main.LevelData;

public class GameWorld
extends FixedThread {
    private static GameWorld self = null;
    private static final int PERIOD = 50;
    public static final int BOUNDARY_TOP = 1;
    public static final int BOUNDARY_RIGHT = 2;
    public static final int BOUNDARY_BOTTOM = 4;
    public static final int BOUNDARY_LEFT = 8;
    private static int width;
    private static int height;
    private static int fWidth;
    private static int fHeight;
    private GameObject[] objects;
    private boolean[][] objectCollisions;
    private GameObject dragging;
    private Edge[] edges;
    private boolean[] edgesTmp;
    private Marker marker;
    private boolean changed;
    private boolean solved;

    protected GameWorld() {
        this.setPeriod(50);
        this.changed = true;
        this.solved = false;
        this.init();
    }

    private void init() {
        if (Variant.isS60()) {
            width = 360;
            height = 640;
        } else {
            width = 240;
            height = 320;
        }
        this.setFWidth(FP.toFP(width));
        this.setFHeight(FP.toFP(height));
        this.setChanged(true);
        this.marker = new Marker("/game/marker.png");
    }

    public void startLevel() {
        LevelData levelData = LevelData.getInstance();
        int n = levelData.getBalls().length;
        int n2 = levelData.getEdges().length;
        if (n > 0 && n2 > 0) {
            int n3;
            this.objects = new GameObject[n];
            this.objectCollisions = new boolean[n][n];
            this.edges = new Edge[n2];
            this.edgesTmp = new boolean[n2];
            for (n3 = 0; n3 < n; ++n3) {
                Ball ball = new Ball();
                ball.setXY(FP.toFP(levelData.getBalls()[n3][0]), FP.toFP(levelData.getBalls()[n3][1]));
                ball.setRadius(FP.toFP(13));
                ball.getVelocity().setXY(0, 0);
                ball.setWorld(this);
                this.objects[n3] = ball;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.edges[n3] = new Edge((Ball)this.objects[levelData.getEdges()[n3][0]], (Ball)this.objects[levelData.getEdges()[n3][1]]);
            }
        } else {
            throw new NullPointerException("Can't load data");
        }
        this.setPaused(false);
        this.setChanged(true);
    }

    public static GameWorld getInstance() {
        if (self == null) {
            self = new GameWorld();
        }
        return self;
    }

    protected void tick() {
        if (this.changed) {
            this.calc();
        }
    }

    public void draw(Antialias antialias) {
        for (int i = 0; i < this.edges.length; ++i) {
            this.edges[i].draw(antialias);
        }
    }

    public void renderMarker(Graphics graphics) {
        if (this.marker.isActive()) {
            this.marker.render(graphics);
        }
    }

    public void render(Graphics graphics) {
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i].render(graphics);
        }
    }

    public static int X(int n) {
        return FP.roundToInt(n);
    }

    public static int Y(int n) {
        return height - FP.roundToInt(n);
    }

    public static int wX(int n) {
        return FP.toFP(n);
    }

    public static int wY(int n) {
        return FP.toFP(height - n);
    }

    public static int getFWidth() {
        return fWidth;
    }

    private void setFWidth(int n) {
        fWidth = n;
    }

    public static int getFHeight() {
        return fHeight;
    }

    private void setFHeight(int n) {
        fHeight = n;
    }

    private void setDraggingPosition(int n, int n2) {
        if (this.dragging != null) {
            this.dragging.saveState();
            this.dragging.setXY(n, n2);
            if (!((Circle)this.dragging.getPhysArea()).isInsideWorld2()) {
                this.dragging.restoreState();
            }
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.dragging == this.objects[i] || !this.dragging.collidesWith(this.objects[i])) continue;
                this.dragging.restoreState();
                break;
            }
            this.marker.setXY(this.dragging.getX(), this.dragging.getY());
            this.marker.setActive(true);
            this.changed = true;
        }
    }

    public void drag(int n, int n2, int n3, int n4) {
        if (this.dragging != null) {
            this.setDraggingPosition(GameWorld.wX(n3), GameWorld.wY(n4));
        } else if (!this.isPaused()) {
            int n5 = -1;
            for (int i = 0; i < this.objects.length; ++i) {
                if (!this.objects[i].getGestureArea().isInside(GameWorld.wX(n), GameWorld.wY(n2))) continue;
                int n6 = this.objects[i].getGestureArea().distance(GameWorld.wX(n), GameWorld.wY(n2));
                if (n5 != -1 && n6 >= n5) continue;
                n5 = n6;
                this.dragging = this.objects[i];
            }
        }
    }

    public void drop(int n, int n2) {
        if (!this.isPaused()) {
            this.setDraggingPosition(GameWorld.wX(n), GameWorld.wY(n2));
            this.dragging = null;
            this.marker.setActive(false);
            this.calc();
            if (this.solved) {
                GameState.getInstance().setSolved(true);
                this.setPaused(true);
            }
            GameState.getInstance().saveStateToDb(this.getDump());
        }
    }

    protected void calc() {
        int n;
        for (n = 0; n < this.edges.length; ++n) {
            this.edgesTmp[n] = false;
        }
        for (n = 0; n < this.edges.length - 1; ++n) {
            for (int i = n + 1; i < this.edges.length; ++i) {
                if (!this.edges[n].intersectsWith(this.edges[i])) continue;
                this.edgesTmp[n] = true;
                this.edgesTmp[i] = true;
            }
        }
        this.solved = true;
        for (n = 0; n < this.edges.length; ++n) {
            this.solved &= !this.edgesTmp[n];
            this.edges[n].setIntersected(this.edgesTmp[n]);
        }
        this.setChanged(false);
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void print() {
    }

    public String getDump() {
        int n;
        String string = new String();
        for (n = 0; n < this.objects.length; ++n) {
            if (n > 0) {
                string = string + " ";
            }
            string = string + FP.roundToInt(this.objects[n].getX()) + "," + FP.roundToInt(this.objects[n].getY());
        }
        string = string + ";";
        for (n = 0; n < this.edges.length; ++n) {
            int n2;
            if (n > 0) {
                string = string + " ";
            }
            for (n2 = 0; n2 < this.objects.length; ++n2) {
                if (this.edges[n].getBall1() != this.objects[n2]) continue;
                string = string + n2;
            }
            string = string + ",";
            for (n2 = 0; n2 < this.objects.length; ++n2) {
                if (this.edges[n].getBall2() != this.objects[n2]) continue;
                string = string + n2;
            }
        }
        return string;
    }
}

