/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.Area;
import gameobjects.GameSprite;
import gameobjects.GameWorld;
import gameobjects.Velocity;

abstract class GameObject
extends GameSprite {
    protected Area physArea;
    protected Area gestureArea;
    protected GameWorld world;
    private Velocity velocity = new Velocity();
    protected int mass = 1000;
    protected int friction;
    private int fLastX;
    private int fLastY;
    private Velocity lastVelocity = new Velocity();
    private int lastMass;
    private int lastFriction;

    public void saveState() {
        this.fLastX = this.fX;
        this.fLastY = this.fY;
        this.lastVelocity.setXY(this.velocity.getX(), this.velocity.getY());
        this.lastMass = this.getMass();
        this.lastFriction = this.friction;
    }

    public void restoreState() {
        this.setXY(this.fLastX, this.fLastY);
        this.getVelocity().setXY(this.lastVelocity.getX(), this.lastVelocity.getY());
        this.getPhysArea().setXY(this.fLastX, this.fLastY);
        this.getGestureArea().setXY(this.fLastX, this.fLastY);
        this.setMass(this.lastMass);
        this.friction = this.lastFriction;
    }

    public void setXY(int n, int n2) {
        this.fX = n;
        this.fY = n2;
        this.getPhysArea().setXY(n, n2);
        this.getGestureArea().setXY(n, n2);
    }

    abstract void tick(int var1);

    public Velocity getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Velocity velocity) {
        this.velocity = velocity;
    }

    void setWorld(GameWorld gameWorld) {
        this.world = gameWorld;
    }

    abstract void collide(GameObject var1);

    boolean collidesWith(GameObject gameObject) {
        return this.getPhysArea().collidesWith(gameObject.getPhysArea());
    }

    abstract void worldCollision();

    public int getMass() {
        return this.mass;
    }

    public void setMass(int n) {
        this.mass = n;
    }

    public Area getPhysArea() {
        return this.physArea;
    }

    public void setPhysArea(Area area) {
        this.physArea = area;
    }

    public Area getGestureArea() {
        return this.gestureArea;
    }

    public void setGestureArea(Area area) {
        this.gestureArea = area;
    }

    public void setX(int n) {
        this.fX = n;
        this.getPhysArea().setX(n);
        this.getGestureArea().setX(n);
    }

    public void setY(int n) {
        this.fY = n;
        this.getPhysArea().setY(n);
        this.getGestureArea().setY(n);
    }
}

