/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import fp.FP;
import gameobjects.Ball;
import helpers.Antialias;
import javax.microedition.lcdui.Graphics;

public class Edge {
    private Ball ball1;
    private Ball ball2;
    private int tX1;
    private int tX2;
    private int tX3;
    private int tX4;
    private int tY1;
    private int tY2;
    private int tY3;
    private int tY4;
    private boolean intersected;
    private int tA1;
    private int tA2;
    private int tB1;
    private int tB2;

    public Edge(Ball ball, Ball ball2) {
        this.ball1 = ball;
        this.ball2 = ball2;
    }

    public void render(Graphics graphics) {
    }

    void draw(Antialias antialias) {
        if (this.isIntersected()) {
            antialias.setColor(0xFF0000);
        } else {
            antialias.setColor(65280);
        }
        antialias.line(this.ball1.getX(), this.ball1.getY(), this.ball2.getX(), this.ball2.getY());
    }

    public boolean intersectsWith(Edge edge) {
        if (this.ball1 == edge.getBall1() || this.ball1 == edge.getBall2() || this.ball2 == edge.getBall1() || this.ball2 == edge.getBall2()) {
            return false;
        }
        this.tX1 = FP.roundToInt(this.ball1.getX());
        this.tY1 = FP.roundToInt(this.ball1.getY());
        this.tX2 = FP.roundToInt(this.ball2.getX());
        this.tY2 = FP.roundToInt(this.ball2.getY());
        this.tX3 = FP.roundToInt(edge.getBall1().getX());
        this.tY3 = FP.roundToInt(edge.getBall1().getY());
        this.tX4 = FP.roundToInt(edge.getBall2().getX());
        this.tY4 = FP.roundToInt(edge.getBall2().getY());
        this.tA1 = (this.tX3 - this.tX1) * (this.tY2 - this.tY1) - (this.tY3 - this.tY1) * (this.tX2 - this.tX1);
        this.tA2 = (this.tX4 - this.tX1) * (this.tY2 - this.tY1) - (this.tY4 - this.tY1) * (this.tX2 - this.tX1);
        if (this.tA1 >= 0 && this.tA2 >= 0 || this.tA1 <= 0 && this.tA2 <= 0) {
            return false;
        }
        this.tB1 = (this.tX1 - this.tX3) * (this.tY4 - this.tY3) - (this.tY1 - this.tY3) * (this.tX4 - this.tX3);
        this.tB2 = (this.tX2 - this.tX3) * (this.tY4 - this.tY3) - (this.tY2 - this.tY3) * (this.tX4 - this.tX3);
        return (this.tB1 < 0 || this.tB2 < 0) && (this.tB1 > 0 || this.tB2 > 0);
    }

    public boolean isIntersected() {
        return this.intersected;
    }

    public void setIntersected(boolean bl) {
        this.intersected = bl;
    }

    public Ball getBall1() {
        return this.ball1;
    }

    public Ball getBall2() {
        return this.ball2;
    }
}

