/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import fp.FP;
import gameobjects.Area;
import gameobjects.GameWorld;
import helpers.Variant;
import javax.microedition.lcdui.Graphics;

public class Circle
extends Area {
    private int fRadius;
    private int[][] variantCoordinates;

    public Circle(int n, int n2, int n3) {
        this.setXY(n, n2);
        this.fRadius = n3;
        this.variantCoordinates = new int[1][2];
        if (Variant.isS60()) {
            this.variantCoordinates[0][0] = FP.toFP(56);
            this.variantCoordinates[0][1] = FP.toFP(588);
        } else {
            this.variantCoordinates[0][0] = FP.toFP(46);
            this.variantCoordinates[0][1] = FP.toFP(275);
        }
    }

    public boolean isInsideWorld2() {
        if (this.getX() + this.fRadius > GameWorld.getFWidth()) {
            return false;
        }
        if (this.getY() - this.fRadius < 0) {
            return false;
        }
        if (this.getX() - this.fRadius < 0) {
            return false;
        }
        if (this.getY() + this.fRadius > GameWorld.getFHeight()) {
            return false;
        }
        return this.getX() > this.variantCoordinates[0][0] || this.getY() < this.variantCoordinates[0][1];
    }

    public boolean isInsideWorld(int n, int n2) {
        return this.getWorldCollision(n, n2) == 0;
    }

    public int getWorldCollision(int n, int n2) {
        int n3 = 0;
        if (FP.add(this.getX(), this.fRadius) > n) {
            n3 |= 2;
        }
        if (FP.sub(this.getY(), this.fRadius) < 0) {
            n3 |= 4;
        }
        if (FP.sub(this.getX(), this.fRadius) < 0) {
            n3 |= 8;
        }
        if (FP.add(this.getY(), this.fRadius) > n2) {
            n3 |= 1;
        }
        return n3;
    }

    public boolean isInside(int n, int n2) {
        int n3;
        int n4;
        int n5 = FP.roundToInt(FP.sub(this.getX(), n));
        return n5 * n5 + (n4 = FP.roundToInt(FP.sub(this.getY(), n2))) * n4 < (n3 = FP.roundToInt(this.fRadius)) * n3;
    }

    public int getRadius() {
        return this.fRadius;
    }

    public void setRadius(int n) {
        this.fRadius = n;
    }

    public void render(Graphics graphics) {
    }

    boolean collidesWith(Area area) {
        if (area instanceof Circle) {
            return this.collidesWith((Circle)area);
        }
        throw new ClassCastException();
    }

    boolean collidesWith(Circle circle) {
        int n;
        int n2;
        int n3 = FP.roundToInt(FP.sub(this.getX(), circle.getX()));
        return n3 * n3 + (n2 = FP.roundToInt(FP.sub(this.getY(), circle.getY()))) * n2 < (n = FP.roundToInt(FP.add(this.fRadius, circle.getRadius()))) * n;
    }

    int distance(int n, int n2) {
        int n3 = FP.roundToInt(this.getX() - n);
        int n4 = FP.roundToInt(this.getY() - n2);
        return (int)Math.sqrt(n3 * n3 + n4 * n4);
    }
}

