/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import fp.FP;
import gameobjects.Circle;
import gameobjects.GameObject;
import helpers.LevelStyle;

public class Ball
extends GameObject {
    public Ball() {
        this.initSprite(LevelStyle.getLevelImage("ball.png"), 27, 28);
        this.physArea = new Circle(0, 0, FP.toFP(10));
        this.gestureArea = new Circle(0, 0, FP.toFP(10));
    }

    void tick(int n) {
        if (this.getVelocity().getX() != 0 || this.getVelocity().getY() != 0) {
            this.setXY(FP.add(this.getX(), this.getVelocity().getX() * n), FP.add(this.getY(), this.getVelocity().getY() * n));
            this.getPhysArea().setXY(this.getX(), this.getY());
            this.getGestureArea().setXY(this.getX(), this.getY());
        }
    }

    void worldCollision() {
        Ball ball = this;
        Ball ball2 = this;
        int n = this.getPhysArea().getWorldCollision(ball.world.getFWidth(), ball2.world.getFHeight());
        if (n != 0) {
            if ((n & 1) != 0) {
                this.getVelocity().setXY(this.getVelocity().getX(), -FP.abs(this.getVelocity().getY()));
            }
            if ((n & 2) != 0) {
                this.getVelocity().setXY(-FP.abs(this.getVelocity().getX()), this.getVelocity().getY());
            }
            if ((n & 4) != 0) {
                this.getVelocity().setXY(this.getVelocity().getX(), FP.abs(this.getVelocity().getY()));
            }
            if ((n & 8) != 0) {
                this.getVelocity().setXY(FP.abs(this.getVelocity().getX()), this.getVelocity().getY());
            }
        }
    }

    void collide(GameObject gameObject) {
        if (!(gameObject instanceof Ball)) {
            throw new ClassCastException();
        }
        this.collide((Ball)gameObject);
    }

    void collide(Ball ball) {
        try {
            int n = FP.atan2(ball.getY() - this.getY(), ball.getX() - this.getX());
            int n2 = FP.cos(n);
            int n3 = FP.sin(n);
            int n4 = FP.mul(this.getVelocity().getX(), n2) + FP.mul(this.getVelocity().getY(), n3);
            int n5 = FP.mul(this.getVelocity().getY(), n2) - FP.mul(this.getVelocity().getX(), n3);
            int n6 = FP.mul(ball.getVelocity().getX(), n2) + FP.mul(ball.getVelocity().getY(), n3);
            int n7 = FP.mul(ball.getVelocity().getY(), n2) - FP.mul(ball.getVelocity().getX(), n3);
            int n8 = FP.mul(this.getMass(), n4) + FP.mul(this.getMass(), n6);
            int n9 = n4 - n6;
            int n10 = FP.div(n8 + FP.mul(this.getMass(), n9), this.getMass() + ball.getMass());
            int n11 = n10 - n9;
            n4 = FP.toFP(n11);
            n6 = FP.toFP(n10);
            this.getVelocity().setXY(FP.mul(n11, n2) - FP.mul(n5, n3), FP.mul(n5, n2) + FP.mul(n11, n3));
            ball.getVelocity().setXY(FP.mul(n10, n2) - FP.mul(n7, n3), FP.mul(n7, n2) + FP.mul(n10, n3));
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    void setRadius(int n) {
        Circle circle = (Circle)this.getPhysArea();
        circle.setRadius(n);
        if (n < 0x280000) {
            n = 0x1E0000;
        }
        circle = (Circle)this.getGestureArea();
        circle.setRadius(n);
    }
}

