/*
 * Decompiled with CFR 0.152.
 */
package fp;

public final class FP {
    public static final int EPSILON = 1;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int FP_1 = 65536;
    public static final int FP_05 = 32768;
    public static final int FP_255 = 0xFF0000;
    public static final int ANGLE_90 = 32768;
    public static final int ANGLE_180 = 16384;
    public static final int ANGLE_270 = 49152;
    private static final short[] LUT_ATAN_1 = new short[]{2558, 6941, -25147, -28189, 26543, 17079, 10588, 6474, 3938, 2391, 1451, 880, 534, 324, 196, 119, 72, 44, 27, 16, 10, 6};
    private static final short[] LUT_ATAN_2 = new short[]{0, 10323, 20042, -29415, -18319, -11225, -6834, -4151, -2519, -1528, -927, -562, -341, -207, -125, -76, -46, -28, -17, -10, -6, -4, -2};
    private static final short[] LUT_COS_1 = new short[]{-20185, -19990, -19603, -19028, -18269, -17334, -16232, -14974, -13571, -12038, -10389, -8640, -6808, -4910, -2965, -992};
    private static final short[] LUT_COS_2 = new short[]{-1, -317, -1260, -2823, -4990, -7739, -11046, -14877, -19196, -23961, -29127, 30892, 25079, 19023, 12784, 6423};
    private static final int[] LUT_EXP_1 = new int[]{65536, 108051, 178145, 293712, 484249, 798392, 1316326, 2170254, 3578144, 5899363, 9726405, 16036130, 26439109, 0x2992442, 71868951, 118491868, 195360063, 322094291, 531043708, 875543058, 1443526462, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    private static final short[] LUT_EXP_2 = new short[]{-1016, -2016, -3001, -3971, -4925, -5865, -6790, -7701, -8597, -9480, -10349, -11205, -12047, -12876, -13693, -14497, -15288, -16067, -16834, -17589, -18332, -19064, -19784, -20494, -21192, -21880, -22556, -23223, -23879, -24525, -25160};
    private static final short[] LUT_EXP_3 = new short[]{-32, -64, -96, -128, -160, -192, -224, -256, -287, -319, -351, -383, -415, -446, -478, -510, -542, -573, -605, -637, -669, -700, -732, -764, -795, -827, -858, -890, -921, -953, -985};
    private static final short[] LUT_LOG_1 = new short[]{2017, 3973, 5873, 7719, 9515, 11262, 12965, 14624, 16242, 17821, 19364, 20870, 22343, 23783, 25193, 26573, 27924, 29248, 30546, 31818, -32469, -31244, -30042, -28861, -27701, -26561, -25441, -24340, -23256, -22191, -21142};
    private static final short[] LUT_LOG_2 = new short[]{64, 128, 192, 256, 319, 383, 446, 510, 573, 637, 700, 764, 827, 890, 953, 1016, 1079, 1142, 1205, 1268, 1330, 1393, 1456, 1518, 1581, 1643, 1706, 1768, 1830, 1892, 1955};
    private static final short[] LUT_SQRT = new short[]{1016, 2017, 3003, 3975, 4934, 5880, 6814, 7735, 8646, 9545, 10433, 11312, 12180, 13039, 13888, 14729, 15561, 16384, 17199, 18006, 18806, 19598, 20382, 21160, 21931, 22695, 23452, 24203, 24948, 25686, 26419};

    public static int abs(int n) {
        if (n >= 0) {
            return n;
        }
        return -n;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static int atan(int n) {
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        if (n < 4) {
            return 0;
        }
        int n2 = FP.log(n);
        int n3 = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = (n3 >> 15 & 0x1F) + 1;
        int n5 = n3 & Short.MAX_VALUE;
        if (n4 == 1) {
            if ((n3 & 0x4000) == 0) {
                n4 = 0;
            }
            n5 = n5 << 1 & Short.MAX_VALUE;
        }
        int n6 = LUT_ATAN_1[n4] & 0xFFFF;
        int n7 = LUT_ATAN_2[n4] & 0xFFFF;
        int n8 = (LUT_ATAN_2[n4 + 1] & 0xFFFF) - n7 + (n6 >> 4);
        int n9 = ((n8 - (n5 * n6 >>> 19)) * n5 >>> 15) + n7 + 4 >>> 3;
        n2 = n2 < 0 ? 8192 - n9 : 8192 + n9;
        if (bl) {
            n2 = -n2;
        }
        return n2 & 0xFFFF;
    }

    public static int atan2(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n2 = -n2;
            n4 = -n;
        } else {
            n4 = n;
        }
        int n5 = n2 < 0 ? -n2 : n2;
        if (n5 < n4 && n5 >= 65536 || n5 >= n4 && n5 < 65536 || n4 == 0) {
            if (n5 == 0) {
                return 0;
            }
            n3 = FP.atan((int)(((long)n4 << 16) / (long)n5));
            if (n2 < 0) {
                n3 = 32768 - n3;
            }
        } else {
            n3 = 16384 - FP.atan((int)(((long)n2 << 16) / (long)n4));
        }
        if (n < 0) {
            n3 += 32768;
        }
        return n3 & 0xFFFF;
    }

    public static int ceil(int n) {
        return n + 65535 & 0xFFFF0000;
    }

    public static int cos(int n) {
        boolean bl;
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n2 & Short.MAX_VALUE;
        boolean bl2 = bl = (n2 & 0x8000) > 0;
        if ((n3 & 0x4000) > 0) {
            if (n3 == 16384) {
                return 0;
            }
            n3 = 32768 - n3;
            bl = !bl;
        }
        int n4 = n3 >> 10 & 0xF;
        int n5 = n3 & 0x3FF;
        short s = LUT_COS_1[n4];
        int n6 = LUT_COS_2[n4] & 0xFFFF;
        int n7 = n4 < 15 ? ((LUT_COS_2[n4 + 1] & 0xFFFF) - n6 << 6) - s : (-1 - n6 << 6) - s;
        int n8 = (((n5 * s >> 10) + n7) * n5 + 32768 >> 16) + (n6 + 1);
        if (bl) {
            return -n8;
        }
        return n8;
    }

    public static int div(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static int exp(int n) {
        int n2;
        int n3 = n;
        if (n < 0) {
            if (n < -700244) {
                if (n < -772244) {
                    return 0;
                }
                return 1;
            }
            n3 = -n;
        } else {
            if (n > 681390) {
                return Integer.MAX_VALUE;
            }
            n3 = n;
        }
        int n4 = n3;
        int n5 = ((n4 >>>= 5) & 0x1F) - 1;
        if (n5 >= 0) {
            n2 = LUT_EXP_3[n5] & 0xFFFF;
            n5 = ((n4 >>>= 5) & 0x1F) - 1;
            if (n5 >= 0) {
                n2 = (n2 * (LUT_EXP_2[n5] & 0xFFFF) >>> 15) + 1 >>> 1;
            }
        } else {
            n5 = ((n4 >>>= 5) & 0x1F) - 1;
            n2 = n5 >= 0 ? LUT_EXP_2[n5] & 0xFFFF : 65536;
        }
        if ((n5 = n3 & 0x1F) > 0) {
            n2 = n2 * (65536 - n5) >>> 15;
            n2 = (n2 >>> 1) + (n2 & 1);
        }
        n5 = (n4 >>>= 5) & 0x1F;
        int n6 = LUT_EXP_1[n5];
        n = n < 0 ? (int)(((long)n2 << 17) / (long)n6) : (int)(((long)n6 << 17) / (long)n2);
        return n + 1 >>> 1;
    }

    public static int floor(int n) {
        return n & 0xFFFF0000;
    }

    public static int fraction(int n) {
        return n & 0xFFFF;
    }

    public static int log(int n) {
        if (n <= 0) {
            return Integer.MIN_VALUE;
        }
        int n2 = n;
        int n3 = -16;
        if ((n2 & 0xFFFF0000) > 0) {
            n2 >>>= 16;
            n3 += 16;
        }
        if ((n2 & 0xFF00) > 0) {
            n2 >>>= 8;
            n3 += 8;
        }
        if ((n2 & 0xF0) > 0) {
            n2 >>>= 4;
            n3 += 4;
        }
        if ((n2 & 0xC) > 0) {
            n2 >>>= 2;
            n3 += 2;
        }
        if ((n2 & 2) > 0) {
            n2 >>>= 1;
            ++n3;
        }
        int n4 = n3 * 45426;
        int n5 = n3 >= 0 ? n >>> n3 + 1 : n << -1 - n3;
        int n6 = n5 >>> 5;
        int n7 = n6 >>> 5;
        int n8 = (n7 & 0x1F) - 1;
        if (n8 >= 0) {
            n4 += LUT_LOG_1[n8] & 0xFFFF;
        }
        if ((n8 = n5 & 0x3E0) >= n7) {
            n4 += LUT_LOG_2[(n8 /= n7) - 1] & 0xFFFF;
            n8 *= n7;
        } else {
            n8 = 0;
        }
        n8 = (n5 & 0x3FF) - n8 << 12;
        if (n8 >= n6) {
            n2 = n8 / n6;
            n4 += n2 + 1 >>> 1;
        }
        return n4;
    }

    public static int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    public static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static int pow(int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        return FP.exp((int)((long)FP.log(n) * (long)n2 >> 16));
    }

    public static int round(int n) {
        return n + 32768 & 0xFFFF0000;
    }

    public static int roundToInt(int n) {
        return n + 32768 >> 16;
    }

    public static int sin(int n) {
        return FP.cos(n - 16384);
    }

    public static int sqrt(int n) {
        int n2;
        if (n <= 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = -16;
        if ((n3 & 0xFFFF0000) > 0) {
            n3 >>>= 16;
            n5 += 16;
        }
        if ((n3 & 0xFF00) > 0) {
            n3 >>>= 8;
            n5 += 8;
        }
        if ((n3 & 0xF0) > 0) {
            n3 >>>= 4;
            n5 += 4;
        }
        if ((n3 & 0xC) > 0) {
            n3 >>>= 2;
            n5 += 2;
        }
        if ((n3 & 2) > 0) {
            n3 >>>= 1;
            ++n5;
        }
        if ((n2 = ((n3 = n5 >= -11 ? n >> 11 + n5 : n << -11 - n5) & 0x1F) - 1) >= 0) {
            n4 = LUT_SQRT[n2] & 0xFFFF;
            if ((n5 & 1) > 0) {
                n4 = n4 * 92682 >>> 16;
            }
        }
        n4 = (n5 & 1) > 0 ? (n4 += 92682) : (n4 += 65536);
        n4 = n5 >= 0 ? (n4 <<= n5 >> 1) : (n4 >>= 1 - n5 >> 1);
        long l = (long)n << 16;
        n4 += (int)(l / (long)n4);
        n4 = n4 + (int)((l << 2) / (long)n4) + 2 >> 2;
        return n4;
    }

    public static int sub(int n, int n2) {
        return n - n2;
    }

    public static int toFP(int n) {
        return n << 16;
    }

    public static int toInt(int n) {
        return n >> 16;
    }

    public static int toFP(String string) throws NumberFormatException {
        int n;
        String string2 = string;
        int n2 = string.length();
        boolean bl = string.charAt(0) == '-';
        int n3 = string.indexOf(46);
        if (n3 != 0 && !bl || n3 != 1 && bl) {
            if (n3 >= 0) {
                string2 = string2.substring(0, n3);
            }
            if (bl) {
                string2 = string2.substring(1);
            }
            try {
                n = Integer.parseInt(string2) << 16;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("For input string: \"" + string + "\"");
            }
        } else {
            n = 0;
        }
        if (++n3 < n2 && n3 != 0) {
            int n4;
            if (string.charAt(n3) == '-') {
                throw new NumberFormatException("For input string: \"" + string + "\"");
            }
            int n5 = n3 + 8;
            if (n5 > n2) {
                n5 = n2;
            }
            try {
                n4 = Integer.parseInt(string.substring(n3, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("For input string: \"" + string + "\"");
            }
            int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
            int n6 = nArray[n5 - n3];
            n += (int)((((long)n4 << 16) + (long)(n6 >> 1)) / (long)n6);
        }
        if (bl) {
            return -n;
        }
        return n;
    }

    public static String toString(int n) {
        String string;
        int n2;
        if (n < 0) {
            n2 = -n;
            string = "-";
        } else {
            n2 = n;
            string = "";
        }
        string = string + Integer.toString(n2 >> 16) + ".";
        n2 = ((n2 & 0xFFFF) << 1) + 1;
        if (n2 == 1) {
            return string + "0";
        }
        for (int i = 0; (n2 = (n2 & 0x1FFFF) * 10) > 0 && i < 5; ++i) {
            string = string + (n2 >> 17);
        }
        return string;
    }

    public static int angleToDeg(int n) {
        return n * 360 / 65536;
    }

    public static int angleToFP(int n) {
        return n % 365 * 65536 / 360;
    }
}

