/*
 * Decompiled with CFR 0.152.
 */
package fonts;

import helpers.ImageLoader;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public abstract class TextWriter {
    protected Hashtable size;
    protected Hashtable position;
    private Sprite sprite;
    private int height;
    private int width;
    private int spaceWidth;

    public TextWriter(String string, int n, int n2) {
        this.width = n;
        this.height = n2;
        try {
            this.sprite = new Sprite(ImageLoader.loadImage(string), n, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.initFont();
    }

    protected abstract void initFont();

    public void draw(String string, Graphics graphics, int n, int n2) {
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            String string2 = string.substring(i, i + 1);
            if (this.position.containsKey(string2) && this.size.containsKey(string2)) {
                this.sprite.setFrame(((Integer)this.position.get(string2)).intValue());
                int n4 = (Integer)this.size.get(string2);
                this.sprite.setRefPixelPosition(n - (this.width - n4) / 2, n2);
                this.sprite.paint(graphics);
                n += n4;
                continue;
            }
            if (!" ".equals(string2)) continue;
            n += this.getSpaceWidth();
        }
    }

    public void drawCentered(String string, Graphics graphics, int n, int n2) {
        String string2;
        int n3;
        int n4 = 0;
        int n5 = string.length();
        for (n3 = 0; n3 < n5; ++n3) {
            string2 = string.substring(n3, n3 + 1);
            if (this.position.containsKey(string2) && this.size.containsKey(string2)) {
                n4 += ((Integer)this.size.get(string2)).intValue();
                continue;
            }
            if (!" ".equals(string2)) continue;
            n4 += this.getSpaceWidth();
        }
        n -= n4 / 2;
        n2 -= this.height / 2;
        for (n3 = 0; n3 < n5; ++n3) {
            string2 = string.substring(n3, n3 + 1);
            if (this.position.containsKey(string2) && this.size.containsKey(string2)) {
                this.sprite.setFrame(((Integer)this.position.get(string2)).intValue());
                int n6 = (Integer)this.size.get(string2);
                this.sprite.setRefPixelPosition(n - (this.width - n6) / 2, n2);
                this.sprite.paint(graphics);
                n += n6;
                continue;
            }
            if (!" ".equals(string2)) continue;
            n += this.getSpaceWidth();
        }
    }

    public String timeMMSS(int n) {
        if (n > 5999000) {
            n = 5999000;
        } else if (n < 0) {
            n = 0;
        }
        int n2 = n / 60000;
        int n3 = n / 1000 % 60;
        if (n2 < 10 && n3 < 10) {
            return "0" + n / 60000 + ":0" + n / 1000 % 60;
        }
        if (n2 < 10 && n3 >= 10) {
            return "0" + n / 60000 + ":" + n / 1000 % 60;
        }
        return n / 60000 + ":" + n / 1000 % 60;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    public void setSpaceWidth(int n) {
        this.spaceWidth = n;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

