/*
 * Decompiled with CFR 0.152.
 */
public class Record
implements Runnable {
    static final int EVENTO_PULSAR = 0;
    static final int EVENTO_SOLTAR = 1;
    static final int EVENTO_ARRASTRAR = 2;
    static final int MODO_NORMAL = 0;
    static final int MODO_SONIDO = 1;
    static boolean ALGUN_RECORD_ACTUALIZADO = false;
    private Piano piano;
    private String titulo;
    private int dim;
    private int instrumento;
    private int offset;
    private int longitud;
    private int instrumentoAnterior;
    private int offsetAnterior;
    private int longitudAnterior;
    private int indice;
    private int[] espaciado;
    private int[] evento;
    private int[] dato;
    private boolean grabando;
    private boolean reproduciendo;
    private long tiempo;

    public Record(int dim, Piano piano) {
        this.piano = piano;
        this.dim = dim;
        this.titulo = "";
        this.longitud = 0;
        this.espaciado = new int[dim];
        this.evento = new int[dim];
        this.dato = new int[dim];
        this.grabando = false;
        this.reproduciendo = false;
    }

    public void init(String data) {
        int iPos2;
        int idato = -3;
        int iPos = 0;
        int indice = 0;
        while ((iPos2 = data.indexOf("|", iPos)) > -1) {
            switch (idato) {
                case -3: {
                    this.titulo = data.substring(iPos, iPos2);
                    break;
                }
                case -2: {
                    this.instrumento = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case -1: {
                    this.offset = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 0: {
                    this.espaciado[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 1: {
                    this.evento[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 2: {
                    this.dato[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    ++indice;
                }
            }
            if (++idato > 2) {
                idato = 0;
            }
            iPos = iPos2 + 1;
        }
        this.longitud = indice;
        indice = 0;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public String getDescripcion() {
        return String.valueOf(new String(this.titulo.length() > 0 ? this.titulo : Idioma.texto_sin_titulo[this.piano.getIdioma()])) + new String(this.longitud > 0 ? " - " + this.piano.getInstrumento(this.instrumento).getNombre(this.piano.getIdioma()) + " (" + String.valueOf(this.getNotas()) + " " + Idioma.texto_notas[this.piano.getIdioma()] + ")" : " (" + Idioma.texto_vacio[this.piano.getIdioma()] + ")");
    }

    public int getLongitud() {
        return this.longitud;
    }

    public int getNotas() {
        int notas = 0;
        int i = 0;
        while (i < this.longitud) {
            if (this.evento[i] == 0) {
                ++notas;
            }
            ++i;
        }
        return notas;
    }

    public boolean reproduciendo() {
        return this.reproduciendo;
    }

    public boolean grabando() {
        return this.grabando;
    }

    public boolean enPausa() {
        return !this.reproduciendo && !this.grabando;
    }

    public void grabar(int instrumento, int offset) {
        this.instrumentoAnterior = this.instrumento;
        this.offsetAnterior = this.offset;
        this.longitudAnterior = this.longitud;
        this.instrumento = instrumento;
        this.offset = offset;
        this.longitud = 0;
        this.indice = 0;
        this.grabando = true;
        this.reproduciendo = false;
        this.piano.getTeclado().crearImagenBarra();
        this.piano.getTeclado().repaint();
        this.tiempo = System.currentTimeMillis();
    }

    public void reproducir() {
        this.indice = 0;
        this.reproduciendo = true;
        this.grabando = false;
        this.piano.setInstrumento(this.instrumento);
        this.piano.getTeclado().crearTeclado();
        if (this.piano.getModo() != 1) {
            this.piano.getTeclado().setOffset(this.offset);
        }
        this.piano.getTeclado().showNotify();
        new Thread(this).start();
    }

    public void parar() {
        if (this.grabando) {
            if (this.longitud > 0) {
                this.piano.crearListaTracks(this.piano.getCodigoRecord());
                ALGUN_RECORD_ACTUALIZADO = true;
            } else {
                this.instrumento = this.instrumentoAnterior;
                this.offset = this.offsetAnterior;
                this.longitud = this.longitudAnterior;
            }
        }
        this.piano.getTeclado().desactivarTeclas();
        this.reproduciendo = false;
        this.grabando = false;
        this.piano.getTeclado().crearImagenBarra();
        this.piano.getTeclado().repaint();
    }

    public void borrar() {
        this.titulo = "";
        this.longitud = 0;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public void restaurar(int melodia) {
        switch (melodia) {
            case 0: {
                this.init("Happy Birthday|0|-2|663|0|0|133|1|0|183|0|0|95|1|0|224|0|2|150|1|2|355|0|0|260|1|0|269|0|5|164|1|5|320|0|4|332|1|4|344|0|0|169|1|0|160|0|0|97|1|0|235|0|2|224|1|2|369|0|0|145|1|0|399|0|7|189|1|7|341|0|5|237|1|5|312|0|0|115|1|0|229|0|0|48|1|0|334|0|12|126|1|12|395|0|9|172|1|9|366|0|5|169|1|5|170|0|5|108|1|5|288|0|4|197|1|4|384|0|2|200|1|2|409|0|10|115|1|10|193|0|10|99|1|10|231|0|9|182|1|9|379|0|5|183|1|5|304|0|7|214|1|7|387|0|5|201|1|5");
                break;
            }
            default: {
                this.borrar();
            }
        }
    }

    public void grabarEvento(int evento, int dato) {
        if (this.indice < this.dim) {
            this.espaciado[this.indice] = (int)(System.currentTimeMillis() - this.tiempo);
            this.evento[this.indice] = evento;
            this.dato[this.indice] = dato;
            ++this.indice;
            this.longitud = this.indice;
        } else {
            this.parar();
        }
        this.tiempo = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.longitud > 0) {
            sb.append(this.titulo.replace('|', ' ')).append("|");
            sb.append(this.instrumento).append("|");
            sb.append(this.offset).append("|");
            int i = 0;
            while (i < this.longitud) {
                sb.append(this.espaciado[i]).append("|");
                sb.append(this.evento[i]).append("|");
                sb.append(this.dato[i]).append("|");
                ++i;
            }
        } else {
            sb.append(this.titulo.replace('|', ' '));
        }
        return sb.toString();
    }

    public void run() {
        this.tiempo = System.currentTimeMillis();
        long tiempo_repaint = 0L;
        while (this.indice < this.longitud && this.reproduciendo) {
            while (System.currentTimeMillis() - this.tiempo < (long)(this.espaciado[this.indice] * 4 / (this.piano.getVelocidad() + 1)) && this.reproduciendo) {
            }
            if (this.reproduciendo) {
                this.tiempo = System.currentTimeMillis();
                switch (this.evento[this.indice]) {
                    case 0: {
                        this.piano.getTeclado().activarTecla(this.dato[this.indice]);
                        break;
                    }
                    case 1: {
                        this.piano.getTeclado().desactivarTecla(this.dato[this.indice]);
                        break;
                    }
                    case 2: {
                        if (this.piano.getModo() == 1) break;
                        this.piano.getTeclado().setOffset(this.piano.getTeclado().getOffset() + this.dato[this.indice]);
                        break;
                    }
                }
                if (this.piano.getModo() != 1 && ((tiempo_repaint += (long)this.espaciado[this.indice]) > 100L || this.indice + 1 < this.longitud && tiempo_repaint + (long)this.espaciado[this.indice + 1] > 100L)) {
                    this.piano.getTeclado().repaint();
                    this.piano.getTeclado().serviceRepaints();
                    tiempo_repaint = 0L;
                }
            }
            ++this.indice;
            if (this.indice != this.longitud || !this.piano.repeticion()) continue;
            this.indice = 0;
            if (this.piano.getModo() == 1) continue;
            this.piano.getTeclado().setOffset(this.offset);
        }
        this.parar();
    }
}

