/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;

public class Piano
extends MIDlet
implements CommandListener,
ItemStateListener {
    private static final String bd = "bdtracks";
    private Inicio inicio;
    private Teclado teclado;
    private Info info;
    private int idioma = 1;
    private int volumen;
    private int instrumento;
    private int sensibilidad;
    private int modo;
    private int velocidad;
    private int track;
    private boolean proximidad;
    private boolean bloqueo;
    private boolean repeticion;
    private Instrumento[] listaInstrumentos;
    private Record[] listaRecords;
    private Command aceptar;
    private Command cancelar;
    private Command volver;
    private Command seleccionar;
    private Command renombrar;
    private Command restaurar;
    private Command borrar;
    private Command si;
    private Command no;
    private Command ayuda;
    private Form fAyuda;
    private Form fAjustes;
    private List lInstrumentos;
    private List lTracks;
    private Alert aAlerta;
    private ChoiceGroup cIdioma;
    private ChoiceGroup cInstrumento;
    private ChoiceGroup cProximidad;
    private ChoiceGroup cTeclado;
    private ChoiceGroup cZoom;
    private ChoiceGroup cBloqueo;
    private ChoiceGroup cModo;
    private ChoiceGroup cVelocidad;
    private ChoiceGroup cRepeticion;
    private Gauge gVolumen;
    private Gauge gSensibilidad;
    private TextBox tTexto;
    private boolean omitirAjustes;
    private boolean saliendo;

    public Piano() {
        String locale = System.getProperty("microedition.locale");
        if (locale != null && locale.length() > 1) {
            String language = locale.substring(0, 2);
            if (language.equals("es")) {
                this.idioma = 0;
            } else if (language.equals("fr")) {
                this.idioma = 2;
            } else if (language.equals("ca")) {
                this.idioma = 3;
            }
        }
        this.volumen = 10;
        this.instrumento = 0;
        this.sensibilidad = 5;
        this.proximidad = true;
        this.bloqueo = false;
        this.modo = 0;
        this.velocidad = 3;
        this.repeticion = false;
        this.track = 0;
        this.omitirAjustes = true;
        this.saliendo = false;
        this.listaInstrumentos = new Instrumento[]{new Instrumento(Idioma.nombre_piano, 0, 4, 10, false), new Instrumento(Idioma.nombre_organo, 49, 5, 10, true), new Instrumento(Idioma.texto_mas_instrumentos, 0, 0, 0, false), new Instrumento(Idioma.nombre_piano_electrico, 0, 0, 0, false), new Instrumento(Idioma.nombre_organo2, 0, 0, 0, true), new Instrumento(Idioma.nombre_violin, 0, 0, 0, true), new Instrumento(Idioma.nombre_flauta, 0, 0, 0, true), new Instrumento(Idioma.nombre_ocarina, 0, 0, 0, true), new Instrumento(Idioma.nombre_armonica, 0, 0, 0, true), new Instrumento(Idioma.nombre_trompeta, 0, 0, 0, true), new Instrumento(Idioma.nombre_saxo, 0, 0, 0, true), new Instrumento(Idioma.nombre_trombon, 0, 0, 0, true), new Instrumento(Idioma.nombre_guitarra, 0, 0, 0, false), new Instrumento(Idioma.nombre_guitarra_electrica, 0, 0, 0, false), new Instrumento(Idioma.nombre_guitarra_electrica2, 0, 0, 0, true), new Instrumento(Idioma.nombre_bajo_electrico, 0, 0, 0, false), new Instrumento(Idioma.nombre_arpa, 0, 0, 0, false), new Instrumento(Idioma.nombre_xilofono, 0, 0, 0, false), new Instrumento(Idioma.nombre_clavicordio, 0, 0, 0, false), new Instrumento(Idioma.nombre_campanas, 0, 0, 0, false), new Instrumento(Idioma.nombre_cristales, 0, 0, 0, false), new Instrumento(Idioma.nombre_trinos, 0, 0, 0, false), new Instrumento(Idioma.nombre_percusion, 0, 0, 0, false)};
        this.listaRecords = new Record[]{new Record(7000, this), new Record(7000, this), new Record(7000, this)};
        this.crearComandos();
        try {
            Imagenes.cargar();
        }
        catch (Exception e) {
            this.mostrarError(new Exception(Idioma.texto_error_imagenes[this.idioma]));
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)bd, (boolean)true);
            int i = 0;
            while (i < rs.getNumRecords()) {
                byte[] bytes = rs.getRecord(i + 1);
                if (bytes != null) {
                    String data = new String(bytes);
                    if (data.indexOf("|") != -1) {
                        this.listaRecords[i].init(new String(data));
                    } else {
                        this.listaRecords[i].setTitulo(data);
                    }
                }
                ++i;
            }
            if (rs.getNumRecords() == 0) {
                this.listaRecords[0].restaurar(0);
                Record.ALGUN_RECORD_ACTUALIZADO = false;
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            this.mostrarError(e);
        }
        this.inicio = new Inicio(this);
        this.info = new Info(this);
        try {
            this.teclado = new Teclado(this);
        }
        catch (Exception e) {
            this.mostrarError(e);
        }
        this.crearAyuda();
        this.crearAjustes();
        this.crearListaInstrumentos();
        this.crearListaTracks(0);
        this.crearTextBox();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.inicio);
    }

    public int getIdioma() {
        return this.idioma;
    }

    public int getVolumen() {
        return this.volumen;
    }

    public void setVolumen(int volumen) {
        this.volumen = volumen;
        this.gVolumen.setValue(volumen);
    }

    public Instrumento getInstrumento() {
        return this.listaInstrumentos[this.instrumento];
    }

    public void setInstrumento(int instrumento) {
        this.instrumento = instrumento;
        this.lInstrumentos.setSelectedIndex(instrumento, true);
        this.cInstrumento.setSelectedIndex(instrumento, true);
    }

    public Instrumento getInstrumento(int codigo) {
        return this.listaInstrumentos[codigo];
    }

    public int getCodigoInstrumento() {
        return this.instrumento;
    }

    public int getSensibilidad() {
        return this.sensibilidad;
    }

    public boolean getProximidad() {
        return this.proximidad;
    }

    public boolean bloqueo() {
        return this.bloqueo;
    }

    public void setBloqueo(boolean bloqueo) {
        this.bloqueo = bloqueo;
        this.cBloqueo.setSelectedIndex(bloqueo ? 1 : 0, true);
    }

    public int getModo() {
        return this.modo;
    }

    public int getVelocidad() {
        return this.velocidad;
    }

    public boolean repeticion() {
        return this.repeticion;
    }

    public Record getRecord() {
        return this.listaRecords[this.track];
    }

    public int getCodigoRecord() {
        return this.track;
    }

    public Teclado getTeclado() {
        return this.teclado;
    }

    private void crearComandos() {
        this.aceptar = new Command(Idioma.command_aceptar[this.idioma], 4, 1);
        this.cancelar = new Command(Idioma.command_cancelar[this.idioma], 3, 1);
        this.volver = new Command(Idioma.command_volver[this.idioma], 3, 1);
        this.seleccionar = new Command(Idioma.command_seleccionar[this.idioma], 8, 1);
        this.renombrar = new Command(Idioma.command_renombrar[this.idioma], 8, 2);
        this.restaurar = new Command(Idioma.command_restaurar[this.idioma], 8, 3);
        this.borrar = new Command(Idioma.command_borrar[this.idioma], 8, 4);
        this.si = new Command(Idioma.command_si[this.idioma], 4, 1);
        this.no = new Command(Idioma.command_no[this.idioma], 3, 1);
        this.ayuda = new Command(Idioma.command_ayuda[this.idioma], 3, 1);
    }

    private void crearListaInstrumentos() {
        String[] lista = new String[this.listaInstrumentos.length];
        int i = 0;
        while (i < this.listaInstrumentos.length) {
            lista[i] = this.listaInstrumentos[i].getNombre(this.idioma);
            ++i;
        }
        this.lInstrumentos = new List(Idioma.titulo_instrumento[this.idioma], 3, lista, null);
        this.lInstrumentos.setSelectedIndex(this.instrumento, true);
        this.lInstrumentos.addCommand(this.seleccionar);
        this.lInstrumentos.addCommand(this.volver);
        this.lInstrumentos.setCommandListener((CommandListener)this);
    }

    protected void crearListaTracks(int indice) {
        String[] lista = new String[this.listaRecords.length + 1];
        int i = 0;
        while (i < this.listaRecords.length) {
            lista[i] = "#" + String.valueOf(i) + " - " + this.listaRecords[i].getDescripcion();
            ++i;
        }
        lista[this.listaRecords.length] = Idioma.texto_mas_tracks[this.idioma];
        this.lTracks = new List(Idioma.titulo_tracks[this.idioma], 3, lista, null);
        this.lTracks.setSelectedIndex(indice, true);
        this.lTracks.addCommand(this.seleccionar);
        this.lTracks.addCommand(this.renombrar);
        this.lTracks.addCommand(this.restaurar);
        this.lTracks.addCommand(this.borrar);
        this.lTracks.addCommand(this.volver);
        this.lTracks.setCommandListener((CommandListener)this);
    }

    private void crearTextBox() {
        this.tTexto = new TextBox(Idioma.texto_titulo[this.idioma], "", 100, 0);
        this.tTexto.addCommand(this.aceptar);
        this.tTexto.addCommand(this.cancelar);
        this.tTexto.setCommandListener((CommandListener)this);
    }

    private void crearAyuda() {
        this.fAyuda = new Form(Idioma.titulo_ayuda[this.idioma]);
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_nota[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_controles[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgVolumen);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_volumen[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgInstrumento);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_instrumento[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgDoble);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_doble_teclado[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgZoom);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_zoom[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgBloqueo);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_bloqueo[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgRecord);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_records[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgAjustes);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_ajustes[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append(Imagenes.imgSalir);
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_salir[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem(Idioma.texto_ayuda_soporte[this.idioma], ""));
        this.fAyuda.append("\n");
        this.fAyuda.append((Item)new StringItem("TM PIANO Lite v. 1.0\n\u00a9 Jorge Broc. Barcelona 2011.", ""));
        this.fAyuda.addCommand(this.aceptar);
        this.fAyuda.setCommandListener((CommandListener)this);
    }

    private void crearAjustes() {
        this.fAjustes = new Form(Idioma.titulo_ajustes[this.idioma]);
        this.cIdioma = new ChoiceGroup(Idioma.texto_idioma[this.idioma], 4, new String[]{"Espa\u00f1ol", "English", "Fran\u00e7ais", "Catal\u00e0"}, new Image[]{Imagenes.imgEs, Imagenes.imgEn, Imagenes.imgFr, Imagenes.imgCa});
        this.cIdioma.setSelectedIndex(this.idioma, true);
        this.fAjustes.append((Item)this.cIdioma);
        this.fAjustes.append("\n");
        this.gVolumen = new Gauge(Idioma.texto_volumen[this.idioma], true, 10, this.volumen);
        this.fAjustes.append((Item)this.gVolumen);
        this.fAjustes.append("\n");
        String[] lista = new String[this.listaInstrumentos.length];
        int i = 0;
        while (i < this.listaInstrumentos.length) {
            lista[i] = this.listaInstrumentos[i].getNombre(this.idioma);
            ++i;
        }
        this.cInstrumento = new ChoiceGroup(Idioma.texto_instrumento[this.idioma], 4, lista, null);
        this.cInstrumento.setSelectedIndex(this.instrumento, true);
        this.fAjustes.append((Item)this.cInstrumento);
        this.fAjustes.append("\n");
        this.gSensibilidad = new Gauge(Idioma.texto_teclado[this.idioma], true, 5, this.sensibilidad);
        this.fAjustes.append((Item)this.gSensibilidad);
        this.fAjustes.append("\n");
        this.cProximidad = new ChoiceGroup("", 4, new String[]{Idioma.texto_proximidad_habilitada[this.idioma], Idioma.texto_proximidad_deshabilitada[this.idioma]}, null);
        this.cProximidad.setSelectedIndex(this.proximidad ? 0 : 1, true);
        this.fAjustes.append((Item)this.cProximidad);
        this.fAjustes.append("\n");
        this.cTeclado = new ChoiceGroup("", 4, new String[]{Idioma.texto_teclado_simple[this.idioma], Idioma.texto_teclado_doble[this.idioma]}, null);
        this.cTeclado.setSelectedIndex(0, true);
        this.fAjustes.append((Item)this.cTeclado);
        this.fAjustes.append("\n");
        this.cZoom = new ChoiceGroup("", 4, new String[]{Idioma.texto_teclas_grandes[this.idioma], Idioma.texto_teclas_medianas[this.idioma], Idioma.texto_teclas_pequenas[this.idioma]}, null);
        this.cZoom.setSelectedIndex(0, true);
        this.fAjustes.append((Item)this.cZoom);
        this.fAjustes.append("\n");
        this.cBloqueo = new ChoiceGroup("", 4, new String[]{Idioma.texto_desbloqueado[this.idioma], Idioma.texto_bloqueado[this.idioma]}, null);
        this.cBloqueo.setSelectedIndex(this.bloqueo ? 1 : 0, true);
        this.fAjustes.append((Item)this.cBloqueo);
        this.fAjustes.append("\n");
        this.cModo = new ChoiceGroup(Idioma.texto_modo_reproduccion[this.idioma], 4, new String[]{Idioma.texto_modo_normal[this.idioma], Idioma.texto_modo_sonido[this.idioma]}, null);
        this.cModo.setSelectedIndex(this.modo, true);
        this.fAjustes.append((Item)this.cModo);
        this.fAjustes.append("\n");
        String[] velocidades = new String[8];
        int i2 = 0;
        while (i2 < velocidades.length) {
            velocidades[i2] = String.valueOf(Idioma.texto_velocidad[this.idioma]) + " " + (i2 + 1) * 25 + "%";
            ++i2;
        }
        this.cVelocidad = new ChoiceGroup("", 4, velocidades, null);
        this.cVelocidad.setSelectedIndex(this.velocidad, true);
        this.fAjustes.append((Item)this.cVelocidad);
        this.fAjustes.append("\n");
        this.cRepeticion = new ChoiceGroup("", 4, new String[]{Idioma.texto_modo_no_repeticion[this.idioma], Idioma.texto_modo_repeticion[this.idioma]}, null);
        this.cRepeticion.setSelectedIndex(this.repeticion ? 1 : 0, true);
        this.fAjustes.append((Item)this.cRepeticion);
        this.fAjustes.addCommand(this.aceptar);
        this.fAjustes.addCommand(this.ayuda);
        this.fAjustes.setItemStateListener((ItemStateListener)this);
        this.fAjustes.setCommandListener((CommandListener)this);
    }

    public void selInstrumento() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lInstrumentos);
    }

    public void selTrack() {
        if (this.listaRecords[this.track].grabando()) {
            this.crearListaTracks(this.lTracks.getSelectedIndex());
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lTracks);
    }

    public void editarTexto() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tTexto);
    }

    public void ajustes() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fAjustes);
    }

    public void ayuda() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fAyuda);
    }

    protected void mostrarError(Exception e) {
        this.aAlerta = new Alert(Idioma.titulo_error[this.idioma], e.getMessage() == null ? String.valueOf(e.toString()) + "\n" + Idioma.texto_error_cerrar[this.idioma] : String.valueOf(e.getMessage()) + "\n" + Idioma.texto_error_cerrar[this.idioma], Imagenes.imgError, AlertType.ERROR);
        this.aAlerta.setTimeout(-2);
        this.aAlerta.addCommand(this.aceptar);
        this.aAlerta.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.aAlerta);
    }

    private void guardarTracks() {
        try {
            RecordStore.deleteRecordStore((String)bd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)bd, (boolean)true);
            int i = 0;
            while (i < this.listaRecords.length) {
                rs.addRecord(this.listaRecords[i].toString().getBytes(), 0, this.listaRecords[i].toString().getBytes().length);
                ++i;
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void infoSalida() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.info);
    }

    protected void confirmarSalida() {
        this.aAlerta = new Alert("TM PIANO", Idioma.texto_alerta_salir[this.idioma], Imagenes.imgAviso, AlertType.ERROR);
        this.aAlerta.setTimeout(-2);
        this.aAlerta.addCommand(this.si);
        this.aAlerta.addCommand(this.no);
        this.aAlerta.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.aAlerta);
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
    }

    private void salir() {
        try {
            this.destroyApp(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.aAlerta) {
            if (!this.saliendo && c == this.no) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.teclado);
            } else if (!this.saliendo && c == this.si && Record.ALGUN_RECORD_ACTUALIZADO) {
                this.saliendo = true;
                this.aAlerta.setString(Idioma.texto_alerta_guardar_tracks[this.idioma]);
            } else {
                if (this.saliendo && c == this.si) {
                    this.guardarTracks();
                }
                this.salir();
            }
        } else if (d == this.tTexto) {
            if (c == this.aceptar && !this.listaRecords[this.lTracks.getSelectedIndex()].getTitulo().equals(this.tTexto.getString())) {
                this.listaRecords[this.lTracks.getSelectedIndex()].setTitulo(this.tTexto.getString());
                this.crearListaTracks(this.lTracks.getSelectedIndex());
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lTracks);
        } else if (d == this.lTracks) {
            if (this.lTracks.getSelectedIndex() >= this.listaRecords.length) {
                this.lTracks.setSelectedIndex(this.track, true);
            } else if (c == this.renombrar) {
                this.tTexto.setString(this.listaRecords[this.lTracks.getSelectedIndex()].getTitulo());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tTexto);
            } else if (c == this.restaurar) {
                this.listaRecords[this.lTracks.getSelectedIndex()].restaurar(this.lTracks.getSelectedIndex());
                this.crearListaTracks(this.lTracks.getSelectedIndex());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lTracks);
            } else if (c == this.borrar) {
                this.listaRecords[this.lTracks.getSelectedIndex()].borrar();
                this.crearListaTracks(this.lTracks.getSelectedIndex());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lTracks);
            } else {
                if (c != this.volver && this.track != this.lTracks.getSelectedIndex()) {
                    this.track = this.lTracks.getSelectedIndex();
                }
                this.lTracks.setSelectedIndex(this.track, true);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.teclado);
            }
        } else if (d == this.lInstrumentos) {
            if (this.lInstrumentos.getSelectedIndex() > 1) {
                this.lInstrumentos.setSelectedIndex(this.instrumento, true);
            } else {
                if (c != this.volver && this.instrumento != this.lInstrumentos.getSelectedIndex()) {
                    this.setInstrumento(this.lInstrumentos.getSelectedIndex());
                    this.teclado.crearTeclado();
                }
                this.lInstrumentos.setSelectedIndex(this.instrumento, true);
                if (this.lInstrumentos.getSelectedIndex() < 2) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.teclado);
                }
            }
        } else if (d == this.fAyuda) {
            if (this.omitirAjustes) {
                this.omitirAjustes = false;
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.teclado);
            } else {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fAjustes);
            }
        } else if (d == this.fAjustes) {
            if (c == this.ayuda) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fAyuda);
            } else {
                this.volumen = this.gVolumen.getValue();
                this.sensibilidad = this.gSensibilidad.getValue();
                this.proximidad = this.cProximidad.getSelectedIndex() == 0;
                boolean bl = this.bloqueo = this.cBloqueo.getSelectedIndex() != 0;
                if (this.cInstrumento.getSelectedIndex() != this.instrumento) {
                    this.setInstrumento(this.cInstrumento.getSelectedIndex());
                    this.teclado.crearTeclado();
                }
                this.modo = this.cModo.getSelectedIndex();
                this.velocidad = this.cVelocidad.getSelectedIndex();
                this.repeticion = this.cRepeticion.getSelectedIndex() != 0;
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.teclado);
            }
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.cIdioma) {
            if (this.cIdioma.getSelectedIndex() != this.idioma) {
                this.idioma = this.cIdioma.getSelectedIndex();
                this.crearComandos();
                this.crearListaInstrumentos();
                this.crearListaTracks(this.lTracks.getSelectedIndex());
                this.crearTextBox();
                this.crearAyuda();
                this.crearAjustes();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fAjustes);
            }
        } else if (item == this.cTeclado) {
            this.cTeclado.setSelectedIndex(0, true);
        } else if (item == this.cZoom) {
            this.cZoom.setSelectedIndex(0, true);
        } else if (item == this.cInstrumento && this.cInstrumento.getSelectedIndex() > 1) {
            this.cInstrumento.setSelectedIndex(this.instrumento, true);
        }
    }
}

